/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules;

import com.ibm.ws.appconversion.jsp.core.model.JspNode;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.JSPResource;
import com.ibm.ws.report.binary.utilities.JspRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class DetectHtmlActionTag
extends DetectRule {
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JspRule);
    protected String[] uriList = null;
    protected String[] htmlActionList = null;

    public DetectHtmlActionTag(String ruleName, String desc, String[] uriList, String[] htmlActionList, DetectRule.FlagOnce flagOnceType, boolean hideResult) {
        super(ruleName, desc, flagOnceType, hideResult);
        this.uriList = uriList;
        this.htmlActionList = htmlActionList;
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        if (detectOnce && !this.detailResults.isEmpty()) {
            return;
        }
        Set<String> keys = store.getJspKeys();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                if (!this.shouldFlag(key)) continue;
                JSPResource jspData = store.getJsp(key);
                List<JspNode> jspNodes = JspRuleUtil.getNodesByTaglibUriList(jspData, this.uriList);
                for (JspNode jspNode : jspNodes) {
                    try {
                        String tagString = jspNode.getData();
                        int startIndex = tagString.indexOf(58) + 1;
                        String actionTagSubstring = tagString.substring(startIndex);
                        String[] stringArray = this.htmlActionList;
                        int n = this.htmlActionList.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String tagRegex = stringArray[n2];
                            if (actionTagSubstring.matches(tagRegex)) {
                                if (this.flag(key)) {
                                    this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, tagRegex, 1, null, jspNode.getLine()));
                                }
                                if (detectOnce || this.flagOnce) {
                                    return;
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

