/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.recorder;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.ReportInputData;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.Rule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class ContainerState {
    private final Map<ReportInputData.ReportType, List<Rule>> rulesNotFired = new HashMap<ReportInputData.ReportType, List<Rule>>();
    private final Map<ReportInputData.ReportType, List<Rule>> rulesFired = new HashMap<ReportInputData.ReportType, List<Rule>>();
    private final Map<ReportInputData.ReportType, List<DetailResult>> detailResults = new HashMap<ReportInputData.ReportType, List<DetailResult>>();
    private Set<ReportInputData.ReportType> activeReportTypes = null;
    List<Rule> configRules = new ArrayList<Rule>();
    private final String containerName;

    public ContainerState(String containerName, Map<ReportInputData.ReportType, Collection<Rule>> initialRules, List<Rule> configRules) {
        this.containerName = containerName;
        this.configRules = configRules;
        if (initialRules != null) {
            for (ReportInputData.ReportType reportType : initialRules.keySet()) {
                Collection<Rule> rules = initialRules.get((Object)reportType);
                ArrayList<Rule> copyOfRules = new ArrayList<Rule>(rules);
                this.rulesNotFired.put(reportType, copyOfRules);
            }
        }
        this.activeReportTypes = initialRules.keySet();
    }

    public void setActiveReportTypes(Set<ReportInputData.ReportType> reportTypes) {
        this.activeReportTypes = reportTypes;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public List<String> getRulesFired(ReportInputData.ReportType reportType) {
        ArrayList<String> returnList = new ArrayList<String>();
        List<Rule> rules = this.rulesFired.get((Object)reportType);
        if (rules != null) {
            for (Rule rule : rules) {
                returnList.add(rule.getRuleName());
            }
        }
        return returnList;
    }

    public void updateRulesFired(SimpleDataStore store, ReportInputData.ReportType reportType) {
        List<Rule> notFired = this.rulesNotFired.get((Object)reportType);
        if (notFired != null) {
            ArrayList<Rule> rulesToMove = new ArrayList<Rule>();
            for (Rule rule : notFired) {
                if (rule.detectRule(store)) {
                    rulesToMove.add(rule);
                }
                rule.clearResults();
            }
            List<Rule> fired = this.rulesFired.get((Object)reportType);
            if (fired == null) {
                fired = new ArrayList<Rule>();
                this.rulesFired.put(reportType, fired);
            }
            for (Rule rule : rulesToMove) {
                fired.add(rule);
                notFired.remove(rule);
            }
        }
    }

    public List<DetailResult> getDetailResults(ReportInputData.ReportType reportType) {
        if (this.detailResults.containsKey((Object)reportType)) {
            return this.detailResults.get((Object)reportType);
        }
        return new ArrayList<DetailResult>();
    }

    public void analyzeDetailResults(SimpleDataStore store, RuleType type) {
        this.analyzeDetailResults(store, type, this.activeReportTypes);
    }

    public void analyzeDetailResults(SimpleDataStore store, RuleType type, Set<ReportInputData.ReportType> ruleSetTypesToScan) {
        for (ReportInputData.ReportType reportType : ruleSetTypesToScan) {
            List<Rule> notFired;
            if (reportType == ReportInputData.ReportType.INVENTORY) {
                ReportUtility.setIgnoreExcludePackages(true);
            } else {
                ReportUtility.setIgnoreExcludePackages(false);
            }
            if (!this.activeReportTypes.contains((Object)reportType) || (notFired = this.rulesNotFired.get((Object)reportType)) == null) continue;
            for (Rule rule : notFired) {
                try {
                    rule.analyze(store, reportType == ReportInputData.ReportType.EVALUATE, type);
                }
                catch (Exception e) {
                    if (ReportUtility.isDebug()) {
                        ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("BinaryReportReader_Error_Processing_Rule_Log"), rule.getRuleDescription()), e);
                        continue;
                    }
                    ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("BinaryReportReader_Error_Processing_Rule"), rule.getRuleDescription(), e.toString()));
                }
            }
        }
    }

    public void analyzeConfig(SimpleDataStore store, RuleType type) {
        if (this.configRules != null && !this.configRules.isEmpty()) {
            for (Rule rule : this.configRules) {
                try {
                    rule.analyze(store, false, type);
                }
                catch (Exception e) {
                    if (ReportUtility.isDebug()) {
                        ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("BinaryReportReader_Error_Processing_Rule_Log"), rule.getRuleDescription()), e);
                        continue;
                    }
                    ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("BinaryReportReader_Error_Processing_Rule"), rule.getRuleDescription(), e.toString()));
                }
            }
        }
    }

    public void updateDetailResults(SimpleDataStore store, Set<ReportInputData.ReportType> reportTypes) {
        for (ReportInputData.ReportType reportType : reportTypes) {
            List<DetailResult> previousResults;
            List<Rule> notFired = this.rulesNotFired.get((Object)reportType);
            if (reportType == ReportInputData.ReportType.INVENTORY) {
                ReportUtility.setIgnoreExcludePackages(true);
            } else {
                ReportUtility.setIgnoreExcludePackages(false);
            }
            if (notFired == null) continue;
            List<Rule> fired = this.rulesFired.get((Object)reportType);
            if (fired == null) {
                fired = new ArrayList<Rule>();
                this.rulesFired.put(reportType, fired);
            }
            if ((previousResults = this.detailResults.get((Object)reportType)) == null) {
                previousResults = new ArrayList<DetailResult>();
                this.detailResults.put(reportType, previousResults);
            }
            for (Rule rule : notFired) {
                List<DetailResult> results = rule.getResults(store);
                rule.clearResults();
                if (results.isEmpty()) continue;
                previousResults.addAll(results);
                if (fired.contains(rule)) continue;
                fired.add(rule);
            }
        }
    }

    public boolean wasRuleFired(Rule theRule, ReportInputData.ReportType reportType) {
        List<Rule> fired = this.rulesFired.get((Object)reportType);
        if (fired != null) {
            return fired.contains(theRule);
        }
        return false;
    }
}

