/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.featurelist;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Feature {
    private final String name;
    private String symbolicName;
    private final FeatureType featureType;
    private final Set<String> enables = new HashSet<String>(8);
    private final Map<String, List<String>> includes = new HashMap<String, List<String>>(8);
    private final Set<String> autoProvisions = new HashSet<String>(2);
    private boolean isSuperseded;
    private boolean isSingleton;
    private final Set<String> supersededBy = new HashSet<String>(6);

    public Feature(String name2, FeatureType featureType) {
        this.name = name2;
        this.featureType = featureType;
    }

    public String getName() {
        return this.name;
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Set<String> getEnables() {
        return this.enables;
    }

    public Map<String, List<String>> getIncludes() {
        return this.includes;
    }

    public boolean isSuperseded() {
        return this.isSuperseded;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public Set<String> getSupersededBy() {
        return this.supersededBy;
    }

    public Set<String> getAutoProvisions() {
        return this.autoProvisions;
    }

    public boolean isAutoFeature() {
        return !this.autoProvisions.isEmpty();
    }

    protected void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    protected void addEnables(String enables) {
        this.enables.add(enables);
    }

    protected void setSuperseded(boolean isSuperseded) {
        this.isSuperseded = isSuperseded;
    }

    protected void setSingleton(boolean isSingleton) {
        this.isSingleton = isSingleton;
    }

    protected void addSupersededBy(String supersededBy) {
        this.supersededBy.add(supersededBy);
    }

    protected void addIncludes(String symbolicName, List<String> versions) {
        this.includes.put(symbolicName, versions);
    }

    protected void addAutoProvision(String autoProvision) {
        this.autoProvisions.add(autoProvision);
    }

    public String toString() {
        return "Feature[" + (this.name != null ? this.name : this.symbolicName) + "]";
    }

    public static enum FeatureType {
        PUBLIC,
        PROTECTED,
        PRIVATE,
        AUTO,
        KERNEL;

    }
}

