/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.resource;

import com.ibm.ws.report.binary.configutility.Scope;
import com.ibm.ws.report.binary.configutility.ScopedObject;
import com.ibm.ws.report.binary.configutility.generator.CommonUtilities;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.logging.Level;

public class Ports
implements ScopedObject {
    private final String _id;
    private final int _portValue;
    private final String _namespace;
    private final String _name;
    private final Scope _scope;

    public Ports(String id, int port, String namespace, String name2, Scope scope) {
        this._id = id;
        this._portValue = port;
        this._namespace = namespace;
        this._name = name2;
        this._scope = scope;
        ReportUtility.logger.get().log(Level.FINEST, "Created httpEndpoint: " + System.getProperty("line.separator") + this);
    }

    public String getId() {
        return this._id;
    }

    public int getPortValue() {
        return this._portValue;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public String getName() {
        return this._name;
    }

    @Override
    public Scope getScope() {
        return this._scope;
    }

    @Override
    public String getUniqueIdentifierName() {
        return this.getScope().getName() + "/" + this.getName();
    }

    @Override
    public boolean equalsAllowDifferentScopes(ScopedObject entry) {
        if (entry == null) {
            return false;
        }
        if (entry == this) {
            return true;
        }
        if (!(entry instanceof Ports)) {
            return false;
        }
        Ports port = (Ports)entry;
        return CommonUtilities.equals(this._id, port.getId()) && CommonUtilities.equals(this._portValue, port.getPortValue()) && CommonUtilities.equals(this._namespace, port.getNamespace()) && CommonUtilities.equals(this._name, port.getName());
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("Endpoint: id= \"" + this._id + "\"" + nl);
        sb.append("port= \"" + this._portValue + "\"" + nl);
        sb.append("namespace= \"" + this._namespace + "\"" + nl);
        sb.append("name= \"" + this._name + "\"" + nl);
        sb.append("scope= \"" + this._scope + "\"" + nl);
        return sb.toString();
    }
}

