/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.resource;

import com.ibm.ws.report.binary.configutility.LibertyResource;
import com.ibm.ws.report.binary.configutility.Scope;
import com.ibm.ws.report.binary.configutility.ScopedObject;
import com.ibm.ws.report.binary.configutility.generator.CommonUtilities;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.logging.Level;

public class JNDIReferenceBinding
implements ScopedObject,
LibertyResource {
    private final Scope _scope;
    private final String _xmiId;
    private final String _libertyId;
    private final String _id;
    private final String _jndiName;
    private final String _factoryRef;

    public JNDIReferenceBinding(Scope scope, String xmiId, String id, String jndiName, String factoryRef) {
        this._scope = scope;
        this._xmiId = xmiId;
        this._id = id;
        this._libertyId = id + "_" + xmiId;
        this._factoryRef = factoryRef;
        this._jndiName = jndiName;
        ReportUtility.logger.get().log(Level.FINEST, "Created JNDIBinding: " + System.getProperty("line.separator") + this);
    }

    @Override
    public Scope getScope() {
        return this._scope;
    }

    public String getId() {
        return this._id;
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public String getFactoryRef() {
        return this._factoryRef;
    }

    @Override
    public String getUniqueIdentifierName() {
        return this._jndiName;
    }

    @Override
    public boolean equalsAllowDifferentScopes(ScopedObject entry) {
        if (entry == null) {
            return false;
        }
        if (entry == this) {
            return true;
        }
        if (!(entry instanceof JNDIReferenceBinding)) {
            return false;
        }
        JNDIReferenceBinding jb = (JNDIReferenceBinding)entry;
        return CommonUtilities.equals(this._jndiName, jb.getJndiName()) && CommonUtilities.equals(this._factoryRef, jb.getJndiName());
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("JNDIBinding: " + nl);
        sb.append("scope=\"" + this._scope + "\"" + nl);
        sb.append("id=\"" + this._id + "\"" + nl);
        sb.append("jndiName=\"" + this._jndiName + "\"" + nl);
        sb.append("value=\"" + this._factoryRef + "\"" + nl);
        sb.append("xmiId=\"" + this._xmiId + "\"" + nl);
        return sb.toString();
    }

    @Override
    public String getLibertyId() {
        return this._libertyId;
    }
}

