/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.generator;

import com.ibm.ws.report.binary.configutility.generator.DeployedCluster;
import com.ibm.ws.report.binary.configutility.generator.DeployedServer;
import com.ibm.ws.report.binary.configutility.twas.Apps;
import com.ibm.ws.report.binary.configutility.twas.Clusters;
import com.ibm.ws.report.binary.configutility.twas.Servers;
import com.ibm.ws.report.inventory.qos.QosSessionPersistenceType;
import com.ibm.ws.report.inventory.qos.QosTransactionLogType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DeploymentEnvironment {
    private final List<DeployedServer> _serverTargets = new ArrayList<DeployedServer>();
    private final List<DeployedCluster> _clusterTargets = new ArrayList<DeployedCluster>();
    private final Apps.App _app;
    private final int _recommendedNumberOfReplicas;
    private final int _recommendedMinimumNumberOfReplicas;
    private final int _recommendedMaximumNumberOfReplicas;

    public DeploymentEnvironment(Apps.App app) {
        this._app = app;
        for (Servers.Server server : app.getServerTargets()) {
            DeployedServer serverTarget = new DeployedServer(server.getLocalServerName(), server.getOwningNode().getNodeName(), server.getServerType());
            this._serverTargets.add(serverTarget);
        }
        Map<String, QosSessionPersistenceType> clusterSessionPersistenceType = app.getClustersSessionReplicationType();
        Map<String, QosTransactionLogType> clusterTransactionLogType = app.getClustersTransactionLogType();
        for (Clusters.Cluster cluster : app.getClusterTargets()) {
            ArrayList<DeployedServer> serverMemberTargets = new ArrayList<DeployedServer>();
            for (Servers.Server server : cluster.getServers()) {
                DeployedServer serverTarget = new DeployedServer(server.getLocalServerName(), server.getOwningNode().getNodeName(), server.getServerType());
                serverMemberTargets.add(serverTarget);
            }
            String clusterName = cluster.getClusterName();
            String clusterXmiId = cluster.getClusterXmiId();
            DeployedCluster clusterTarget = null;
            QosSessionPersistenceType sessionPersistenceType = clusterSessionPersistenceType.get(clusterName) != null ? clusterSessionPersistenceType.get(clusterName) : QosSessionPersistenceType.NONE;
            QosTransactionLogType transactionLogType = clusterTransactionLogType.get(clusterName) != null ? clusterTransactionLogType.get(clusterName) : QosTransactionLogType.NONE;
            boolean isDefaultConfigCluster = false;
            if (this._clusterTargets.size() == app.getClusterTargetCount() - 1) {
                isDefaultConfigCluster = true;
            }
            if (cluster.getDynamicCluster() != null) {
                Clusters.DynamicCluster dynamicCluster = cluster.getDynamicCluster();
                clusterTarget = new DeployedCluster(clusterName, clusterXmiId, serverMemberTargets, sessionPersistenceType, transactionLogType, true, dynamicCluster.getMinInstances(), dynamicCluster.getMaxInstances(), cluster.getMinReplicasValueForCluster(), cluster.getMaxReplicasValueForCluster(), isDefaultConfigCluster);
            } else {
                clusterTarget = new DeployedCluster(clusterName, clusterXmiId, serverMemberTargets, sessionPersistenceType, transactionLogType, isDefaultConfigCluster);
            }
            this._clusterTargets.add(clusterTarget);
        }
        if (this._clusterTargets.size() == 1) {
            DeployedCluster target = this._clusterTargets.get(0);
            if (target.isDynamicCluster()) {
                this._recommendedMinimumNumberOfReplicas = target.getEffectiveMinInstances();
                this._recommendedMaximumNumberOfReplicas = target.getEffectiveMaxInstances();
            } else {
                this._recommendedMinimumNumberOfReplicas = -1;
                this._recommendedMaximumNumberOfReplicas = -1;
            }
            this._recommendedNumberOfReplicas = target.getServerMembers().size();
        } else {
            this._recommendedNumberOfReplicas = -1;
            this._recommendedMinimumNumberOfReplicas = -1;
            this._recommendedMaximumNumberOfReplicas = -1;
        }
    }

    public List<DeployedServer> getDeployedServers() {
        return this._serverTargets;
    }

    public List<DeployedCluster> getDeployedClusters() {
        return this._clusterTargets;
    }

    public int getRecommendedNumberOfReplicas() {
        return this._recommendedNumberOfReplicas;
    }

    public int getRecommendedMinimumNumberOfReplicas() {
        return this._recommendedMinimumNumberOfReplicas;
    }

    public int getRecommendedMaximumNumberOfReplicas() {
        return this._recommendedMaximumNumberOfReplicas;
    }

    public String getCellName() {
        return this._app.getCell().getCellName();
    }

    public String getCellType() {
        return this._app.getCell().getCellType();
    }

    public int getCellAdminPort() {
        return this._app.getCell().getCellAdminPort();
    }

    public String getCellAdminHost() {
        return this._app.getCell().getCellAdminHost();
    }

    public String getCellAdminWASVersion() {
        return this._app.getCell().getCellAdminWASVersion();
    }

    public String getCellAdminWASEdition() {
        return this._app.getCell().getCellAdminWASEdition();
    }

    public boolean isCellZos() {
        return this._app.getCell().isCellZos();
    }

    public boolean isMixedCell() {
        return !this.getCellAdminWASVersion().equals(this.getOldestWebSphereVersion());
    }

    public String getOldestWebSphereVersion() {
        return this._app.getOldestWebSphere();
    }

    public String getOldestJavaVersion() {
        return this._app.getOldestJava();
    }

    public String getOldestJpaVersion() {
        return this._app.getOldestJpaProvider();
    }

    public String getOldestJaxrsVersion() {
        return this._app.getOldestJaxrsProvider();
    }

    public String getOldestJsfVersion() {
        return this._app.getOldestJsfProvider();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String nl = System.getProperty("line.separator");
        sb.append("Deployment Environment - Deployed Clusters:");
        for (DeployedCluster cluster : this._clusterTargets) {
            sb.append(nl + cluster);
        }
        sb.append(nl + "Deployed Servers:");
        for (DeployedServer server : this._serverTargets) {
            sb.append(nl + server);
        }
        sb.append(nl + "Recommended Number of Replicas: " + this._recommendedNumberOfReplicas);
        String edition = this.isCellZos() ? "z/OS" : (this.getCellAdminWASEdition().equals("ND") ? "Network Deployment" : "Base");
        sb.append(nl + "WebSphere Application Server " + edition + " Edition  ver(" + this.getCellAdminWASVersion() + ")");
        sb.append(nl + "Cellname: " + this.getCellName() + " Admin Host/Port: " + this.getCellAdminHost() + "/" + this.getCellAdminPort());
        if ("distributed".equalsIgnoreCase(this.getCellType())) {
            sb.append(nl + "Mixed version cell: " + this.isMixedCell());
            sb.append(nl + "Oldest WebSphere Version: " + this.getOldestWebSphereVersion());
            sb.append(nl + "Oldest Java Version: " + this.getOldestJavaVersion());
            sb.append(nl + "Oldest JPA Version: " + this.getOldestJpaVersion());
            sb.append(nl + "Oldest JAXRS Version: " + this.getOldestJaxrsVersion());
            sb.append(nl + "Oldest JSF Version: " + this.getOldestJsfVersion());
        } else {
            sb.append(nl + "Java Version: " + this.getOldestJavaVersion());
            sb.append(nl + "JPA Version: " + this.getOldestJpaVersion());
            sb.append(nl + "JAXRS Version: " + this.getOldestJaxrsVersion());
            sb.append(nl + "JSF Version: " + this.getOldestJsfVersion());
        }
        return sb.toString();
    }
}

