/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.cmdline.utilities;

import com.ibm.ws.report.binary.ReportInputData;
import com.ibm.ws.report.binary.cmdline.Messages;
import com.ibm.ws.report.utilities.FileHelper;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class ConfigUtility {
    private ConfigUtility() {
        throw new IllegalStateException("Utility class");
    }

    public static String getProfilePath(File app, Map<File, String> mapOfAppsToProfiles, Map<String, String> mapOfProfilesToPaths) {
        if (mapOfAppsToProfiles != null && mapOfProfilesToPaths != null) {
            String profileName = mapOfAppsToProfiles.get(app);
            String profilePath = mapOfProfilesToPaths.get(profileName);
            return profilePath;
        }
        return null;
    }

    public static void populateAppToConfigDir(Map<File, File> appToConfigDir, Map<File, String> mapOfAppsToProfiles, Map<String, String> mapOfProfilesToPaths, File profileDir, EnumSet<ReportInputData.ReportType> reportTypes) {
        Pattern applicationConfigPath = Pattern.compile("^(.+)[\\\\/]config[\\\\/]cells[\\\\/][^/]+[\\\\/]applications[\\\\/]([^/]+)[\\\\/].+$");
        ArrayList<String> listOfAppsUnableToProcess = new ArrayList<String>();
        boolean isValidProfileDir = true;
        for (Map.Entry<File, File> entry : appToConfigDir.entrySet()) {
            Matcher appInConfig;
            File app = entry.getKey();
            String profilePath = ConfigUtility.getProfilePath(app, mapOfAppsToProfiles, mapOfProfilesToPaths);
            String appPath = app.getAbsolutePath();
            if (profilePath == null && (appInConfig = applicationConfigPath.matcher(appPath)).matches()) {
                profilePath = appInConfig.group(1);
            }
            if (profilePath != null) {
                File profileLocation = new File(profilePath);
                try {
                    if (profileDir != null && !profileDir.getCanonicalPath().equals(profileLocation.getCanonicalPath())) {
                        ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("ConfigUtility_AppDeployed"), profilePath, appPath));
                    }
                }
                catch (IOException ex) {
                    ReportUtility.logger.get().log(Level.FINE, "Caught IOException checking if configLocation matches deployed location, we will just assume it does so no INFO message will be sent.", ex);
                }
                appToConfigDir.put(app, profileLocation);
                ReportUtility.logger.get().log(Level.FINEST, Messages.getFormattedMessage(Messages.getString("ConfigUtility_AppDeployed"), profilePath, appPath));
                continue;
            }
            if (profileDir != null && isValidProfileDir) {
                String[] appNodes = appPath.split(File.separator.replace("\\", "\\\\"));
                String appName = appNodes[appNodes.length - 1];
                File cellDir = new File(profileDir, "config/cells");
                if (cellDir.isDirectory()) {
                    for (File cellNameDir : ReportUtility.nullGuard(cellDir.listFiles())) {
                        if (!cellNameDir.isDirectory()) continue;
                        File appDir = new File(cellNameDir, "applications/" + appName);
                        if (!appDir.exists() || !appDir.isDirectory()) {
                            if (!appName.endsWith(".war")) continue;
                            String earAppName = appName.substring(0, appName.length() - 4).concat("_war.ear");
                            appDir = new File(cellNameDir, "applications/" + earAppName);
                            if (!appDir.exists() || !appDir.isDirectory()) continue;
                        }
                        appToConfigDir.put(app, profileDir);
                        ReportUtility.logger.get().log(Level.FINEST, Messages.getFormattedMessage(Messages.getString("ConfigUtility_AppDeployed"), profileDir, appPath));
                        break;
                    }
                } else {
                    isValidProfileDir = false;
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ConfigUtility_ConfigNotFound"), cellDir));
                }
                if (!isValidProfileDir || entry.getValue() != null) continue;
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ConfigUtility_AppNotDeployed"), appPath, profileDir));
                continue;
            }
            listOfAppsUnableToProcess.add(appPath);
        }
        StringBuilder sb = new StringBuilder();
        if (!listOfAppsUnableToProcess.isEmpty() && reportTypes != null) {
            boolean first = true;
            for (String app : listOfAppsUnableToProcess) {
                if (first) {
                    first = false;
                } else {
                    sb.append("\n");
                }
                sb.append(app);
            }
            if (reportTypes.contains((Object)ReportInputData.ReportType.GENERATE_CONFIG)) {
                ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("ConfigUtility_CellNotFound_Config"), sb.toString()));
            } else if (reportTypes.contains((Object)ReportInputData.ReportType.INVENTORY)) {
                ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("ConfigUtility_CellNotFound_Inventory"), sb.toString()));
            }
        }
    }

    public static File getValidPath(String app, boolean dirCheck) throws IOException {
        app = app != null && !app.matches("^\\s*$") ? app.replaceAll("[/\\\\]+", "/") : null;
        File appFile = null;
        if (app != null) {
            appFile = new File(app);
            if (!((appFile = appFile.getCanonicalFile()).exists() && appFile.canRead() && (appFile.isFile() && !dirCheck || appFile.isDirectory() && dirCheck))) {
                appFile = null;
                ReportUtility.logger.get().log(Level.FINE, Messages.getFormattedMessage(Messages.getString("ConfigUtility_InvalidApp"), app));
            }
        }
        return appFile;
    }

    public static Document getDocument(File xmlDocument) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            FileHelper.secureXMLReading(docBuilderFactory);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            return docBuilder.parse(xmlDocument);
        }
        catch (Exception e) {
            ReportUtility.logger.get().log(Level.FINE, Messages.getFormattedMessage(Messages.getString("ConfigUtility_UnableToParseDeploymentXml"), xmlDocument.getName(), e.toString()));
            return null;
        }
    }
}

