/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.asm.utilities;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.ClassOrPackageOccurrence;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class ClassOrPackageDetails {
    private static boolean DEBUG = false;
    private String classOrPackageName = null;
    private int occurrences = 0;
    private Map<String, ClassOrPackageOccurrence> referenceAndLine = new HashMap<String, ClassOrPackageOccurrence>();
    public static final int OTHER = 0;
    public static final int METHOD_RETURN = 1;
    public static final int ANNOTATION = 2;
    public static final int METHOD_PARAMETER = 3;
    public static final int LOCAL_VARIABLE = 4;
    public static final int THROWS_EXCEPTION = 5;
    public static final int CATCH_EXCEPTION = 6;

    public ClassOrPackageDetails(String name2, String reference, int lineNumber) {
        this(name2, reference, lineNumber, 0);
    }

    public ClassOrPackageDetails(String name2, String reference, int lineNumber, int type) {
        this.classOrPackageName = name2;
        this.addOccurrence(reference, lineNumber, type);
    }

    public ClassOrPackageDetails(String name2, String reference, int lineNumber, int type, String className) {
        this.classOrPackageName = name2;
        this.addOccurrence(reference, lineNumber, type, className);
    }

    public void addOccurrence(String reference, int lineNumber) {
        this.addOccurrence(reference, lineNumber, 0, null);
    }

    public void addOccurrence(String reference, int lineNumber, int type) {
        this.addOccurrence(reference, lineNumber, type, null);
    }

    public void addOccurrence(String reference, int lineNumber, int type, String className) {
        ++this.occurrences;
        ReportUtility.logger.get().log(Level.FINEST, "PackageDetails.addOccurrence for name: " + this.classOrPackageName + " occurences: " + this.occurrences + System.getProperty("line.separator") + "     reference: " + reference + " line: " + lineNumber);
        if (this.referenceAndLine.containsKey(reference)) {
            ClassOrPackageOccurrence lines = this.referenceAndLine.get(reference);
            lines.addOccurrence(type, lineNumber, className);
        } else {
            ClassOrPackageOccurrence copo = new ClassOrPackageOccurrence(reference, type, lineNumber, className);
            this.referenceAndLine.put(reference, copo);
        }
    }

    public String getClassOrPackageName() {
        return this.classOrPackageName;
    }

    public int getOccurrences() {
        return this.occurrences;
    }

    public Map<String, ClassOrPackageOccurrence> getReferenceAndLineInfo() {
        return this.referenceAndLine;
    }

    public static String getTypeDescription(int type) {
        String desc = null;
        switch (type) {
            case 1: {
                desc = Messages.getString("Report_Reference_Method_Return");
                break;
            }
            case 2: {
                desc = Messages.getString("Report_Reference_Annotation");
                break;
            }
            case 3: {
                desc = Messages.getString("Report_Reference_Method_Parameter");
                break;
            }
            case 4: {
                desc = Messages.getString("Report_Reference_Local_Variable");
                break;
            }
            case 5: {
                desc = Messages.getString("Report_Reference_Throws_Exception");
                break;
            }
            case 6: {
                desc = Messages.getString("Report_Reference_Catch_Exception");
            }
        }
        return desc;
    }
}

