/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.appconversion.jsp.core.parser;

import com.ibm.ws.appconversion.jsp.core.model.JspNode;
import com.ibm.ws.appconversion.jsp.core.model.JspNodeType;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class JspParser {
    private final InputStream jspStream;
    private Reader jspReader;
    private int line = 1;
    private int offset;
    private final Stack<JspNode> stack = new Stack();
    private JspNode currentNode;
    private final StringBuffer fileContents = new StringBuffer();
    private final Map<Integer, Integer> offsetLineNumberMap = new HashMap<Integer, Integer>();
    private final JspNode root = new JspNode(0, 0, JspNodeType.ROOT);
    private final boolean isJSPX;

    public JspParser(InputStream is, String fileName) {
        this(is, fileName, "UTF-8");
    }

    public JspParser(InputStream is, String fileName, String charSetName) {
        this.isJSPX = fileName.endsWith(".jspx");
        this.jspStream = is;
        try {
            this.jspReader = new InputStreamReader(is, charSetName);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public List<JspNode> getJSPNodes() throws IOException {
        ArrayList<JspNode> arrayList;
        try {
            Character c;
            ArrayList<JspNode> nodes = new ArrayList<JspNode>();
            Character prevChar = Character.valueOf(' ');
            this.stack.push(this.root);
            this.currentNode = this.root;
            nodes.add(this.root);
            while ((c = this.readChar()) != null) {
                JspNode node;
                if (prevChar.charValue() == '\\') {
                    this.processChar(c);
                } else if (c.charValue() == '<') {
                    if (this.stack.isEmpty()) {
                        this.stack.add(this.currentNode);
                    }
                    if ((node = this.stack.peek()) != null && (JspNodeType.SCRIPTLET.equals((Object)node.getJspNodeType()) || JspNodeType.DECLARATION.equals((Object)node.getJspNodeType()) || JspNodeType.EXPRESSION.equals((Object)node.getJspNodeType())) || JspNodeType.JSP_COMMENT.equals((Object)node.getJspNodeType()) || JspNodeType.DIRECTIVE.equals((Object)node.getJspNodeType())) {
                        this.processChar(c);
                    } else {
                        node = this.processNewTag(c.charValue());
                        if (node != null) {
                            nodes.add(node);
                        }
                    }
                } else if (c.charValue() == '$' || c.charValue() == '#') {
                    node = this.stack.peek();
                    if (node != null && (JspNodeType.JSP_COMMENT.equals((Object)node.getJspNodeType()) || JspNodeType.DIRECTIVE.equals((Object)node.getJspNodeType()))) {
                        this.processChar(c);
                    } else {
                        node = this.processNewELTag(c.charValue());
                        if (node != null) {
                            nodes.add(node);
                        }
                    }
                } else {
                    this.processChar(c);
                }
                prevChar = c;
            }
            this.root.replaceData(this.fileContents.toString());
            arrayList = nodes;
        }
        catch (Throwable throwable) {
            try {
                if (this.jspReader != null) {
                    this.jspReader.close();
                }
                if (this.jspStream != null) {
                    this.jspStream.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (this.jspReader != null) {
                this.jspReader.close();
            }
            if (this.jspStream != null) {
                this.jspStream.close();
            }
        }
        catch (Exception exception) {}
        return arrayList;
    }

    public Map<Integer, Integer> getOffsetLineNumberMap() {
        return this.offsetLineNumberMap;
    }

    private void processChar(Character c) {
        if (c.charValue() == '>' || c.charValue() == '}') {
            JspNode node = this.stack.peek();
            node.addData(c.charValue());
            String currentStackData = node.getData();
            if (currentStackData.startsWith("<%--")) {
                if (currentStackData.endsWith("--%>") && node.getJspNodeType() != JspNodeType.ROOT) {
                    this.stack.pop();
                    this.currentNode = this.stack.peek();
                    this.currentNode.addData(node.getData());
                }
            } else if (currentStackData.startsWith("<%") && currentStackData.endsWith("%>") && node.getJspNodeType() != JspNodeType.ROOT) {
                this.stack.pop();
                this.currentNode = this.stack.peek();
                this.currentNode.addData(node.getData());
            } else if (currentStackData.startsWith("<!")) {
                this.stack.pop();
                this.currentNode = this.stack.peek();
                this.currentNode.addData(node.getData());
            } else if (currentStackData.startsWith("</")) {
                this.stack.pop();
                this.currentNode = this.stack.peek();
                String tag = currentStackData.substring(2, currentStackData.length() - 1);
                if (this.currentNode.getData().toUpperCase().startsWith("<" + tag.toUpperCase())) {
                    this.currentNode.addData(node.getData());
                    currentStackData = this.currentNode.getData();
                    this.setPossibleHTMLAction(this.currentNode);
                    this.stack.pop();
                    if (!this.stack.isEmpty()) {
                        this.currentNode = this.stack.peek();
                        this.currentNode.addData(currentStackData);
                    } else if (this.isJSPX) {
                        this.stack.add(this.currentNode);
                    }
                } else {
                    this.currentNode.addData(node.getData());
                }
            } else if (currentStackData.startsWith("<") && currentStackData.endsWith(">")) {
                this.setPossibleHTMLAction(node);
                if (node.getJspNodeType().equals((Object)JspNodeType.HTML_ACTION) || node.getJspNodeType().equals((Object)JspNodeType.DIRECTIVE)) {
                    this.stack.pop();
                    this.currentNode = this.stack.peek();
                    this.currentNode.addData(node.getData());
                }
            } else if ((currentStackData.startsWith("${") || currentStackData.startsWith("#{")) && currentStackData.endsWith("}")) {
                this.stack.pop();
                this.currentNode = this.stack.peek();
                this.currentNode.addData(node.getData());
            } else if (currentStackData.toUpperCase().startsWith("<BR>") || currentStackData.toUpperCase().startsWith("<META ") || currentStackData.toUpperCase().startsWith("<LINK ")) {
                this.stack.pop();
                this.currentNode = this.stack.peek();
                this.currentNode.addData(node.getData());
            }
        } else {
            this.currentNode.addData(c.charValue());
        }
    }

    private void setPossibleHTMLAction(JspNode node) {
        if (node == null) {
            return;
        }
        if (JspNodeType.JSP_ACTION.equals((Object)node.getJspNodeType())) {
            if (node.getData().startsWith("<jsp:directive")) {
                node.setJspNodeType(JspNodeType.DIRECTIVE);
            }
            return;
        }
        if (node.getData().startsWith("<")) {
            char[] chars;
            char[] cArray = chars = node.getData().toCharArray();
            int n = chars.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c == ':') {
                    node.setJspNodeType(JspNodeType.HTML_ACTION);
                    break;
                }
                if (c == ' ' || c == '/' || c == '>' || c == '\r' || c == '\n') break;
                ++n2;
            }
        }
    }

    private JspNode processNewTag(char prevChar) throws IOException {
        Character c = this.readChar();
        if (c == null) {
            return new JspNode(this.line, this.offset, JspNodeType.INVALID);
        }
        JspNode node = null;
        if (c.charValue() == '%') {
            return this.processAmp();
        }
        if (c.charValue() == 'j') {
            return this.processPossibleJSPDirective();
        }
        if (c.charValue() == '!') {
            return this.processExlamation();
        }
        if (c.charValue() == '/') {
            this.currentNode = node = new JspNode(this.line, this.offset - 2);
            node.setJspNodeType(JspNodeType.END_NODE);
            node.addData("</");
            node.setParent(this.stack.peek());
            this.stack.push(node);
            return node;
        }
        node = this.stack.peek();
        if (node.getData().startsWith("<script") && node.getJspNodeType() != JspNodeType.ROOT) {
            node.addData("<");
            node.addData(c.charValue());
            return null;
        }
        node = new JspNode(this.line, this.offset - 2);
        node.setJspNodeType(JspNodeType.HTML);
        node.addData("<");
        node.addData(c.charValue());
        node.setParent(this.stack.peek());
        this.stack.push(node);
        this.currentNode = node;
        return node;
    }

    private JspNode processNewELTag(char prevChar) throws IOException {
        Character c = this.readChar();
        if (c == null) {
            return new JspNode(this.line, this.offset, JspNodeType.INVALID);
        }
        JspNode node = null;
        if (c.charValue() == '{') {
            return this.processEL(prevChar);
        }
        node = this.stack.peek();
        node.addData(prevChar);
        node.addData(c.charValue());
        return null;
    }

    private JspNode processExlamation() throws IOException {
        Character c = this.readChar();
        if (c == null) {
            return new JspNode(this.line, this.offset, JspNodeType.INVALID);
        }
        JspNode node = new JspNode(this.line, this.offset - 3);
        if (c.charValue() == '-') {
            node.setJspNodeType(JspNodeType.HTML_COMMENT);
            node.addData("<!-");
            node.addData(this.readUntil("-->").toString());
        } else {
            node.setJspNodeType(JspNodeType.HTML);
            node.addData("<!");
            node.addData(c.charValue());
            node.addData(this.readUntil(">").toString());
        }
        node.setParent(this.stack.peek());
        this.currentNode = node;
        return node;
    }

    private StringBuffer readUntil(String endingToken) throws IOException {
        boolean read = true;
        StringBuffer sb = new StringBuffer();
        while (read) {
            Character c = this.readChar();
            if (c == null) {
                read = false;
                break;
            }
            sb.append(c);
            if (!sb.toString().endsWith(endingToken)) continue;
            read = false;
            break;
        }
        return sb;
    }

    private JspNode processPossibleJSPDirective() throws IOException {
        JspNode node;
        Character c = Character.valueOf('j');
        Character cp1 = this.readChar();
        if (cp1 == null) {
            return new JspNode(this.line, this.offset, JspNodeType.INVALID);
        }
        if (cp1.charValue() == 's') {
            Character cp2 = this.readChar();
            if (cp2 == null) {
                return new JspNode(this.line, this.offset, JspNodeType.INVALID);
            }
            if (cp2.charValue() == 'p') {
                Character cp3 = this.readChar();
                if (cp3 == null) {
                    return new JspNode(this.line, this.offset, JspNodeType.INVALID);
                }
                if (cp3.charValue() == ':') {
                    node = new JspNode(this.line, this.offset - 5);
                    node.setJspNodeType(JspNodeType.JSP_ACTION);
                    node.addData("<jsp:");
                } else {
                    node = new JspNode(this.line, this.offset - 4);
                    node.setJspNodeType(JspNodeType.HTML);
                    node.addData("<");
                    node.addData(c.charValue());
                    node.addData(cp1.charValue());
                    node.addData(cp2.charValue());
                    node.addData(cp3.charValue());
                }
            } else {
                node = new JspNode(this.line, this.offset - 3);
                node.setJspNodeType(JspNodeType.HTML);
                node.addData("<");
                node.addData(c.charValue());
                node.addData(cp1.charValue());
                node.addData(cp2.charValue());
            }
        } else {
            node = new JspNode(this.line, this.offset - 2);
            node.setJspNodeType(JspNodeType.HTML);
            node.addData("<");
            node.addData(c.charValue());
            node.addData(cp1.charValue());
        }
        node.setParent(this.stack.peek());
        this.stack.push(node);
        this.currentNode = node;
        return node;
    }

    private JspNode processAmp() throws IOException {
        JspNode node;
        Character c = this.readChar();
        if (c == null) {
            return new JspNode(this.line, this.offset, JspNodeType.INVALID);
        }
        if (c.charValue() == '@' || c.charValue() == '!' || c.charValue() == '=' || c.charValue() == '-') {
            node = new JspNode(this.line, this.offset - 3);
            if (c.charValue() == '@') {
                node.setJspNodeType(JspNodeType.DIRECTIVE);
                node.addData("<%@");
            }
            if (c.charValue() == '!') {
                node.setJspNodeType(JspNodeType.DECLARATION);
                node.addData("<%!");
            }
            if (c.charValue() == '=') {
                node.setJspNodeType(JspNodeType.EXPRESSION);
                node.addData("<%=");
            }
            if (c.charValue() == '-') {
                Character cp1 = this.readChar();
                if (cp1 == null) {
                    return new JspNode(this.line, this.offset, JspNodeType.INVALID);
                }
                if (cp1.charValue() == '-') {
                    node = new JspNode(this.line, this.offset - 3);
                    node.setJspNodeType(JspNodeType.JSP_COMMENT);
                    node.addData("<%--");
                } else {
                    node = new JspNode(this.line, this.offset - 3);
                    node.setJspNodeType(JspNodeType.SCRIPTLET);
                    node.addData("<%-");
                    node.addData(cp1.charValue());
                }
            }
        } else {
            node = new JspNode(this.line, this.offset - 3);
            node.setJspNodeType(JspNodeType.SCRIPTLET);
            node.addData("<%");
            node.addData(c.charValue());
        }
        node.setParent(this.stack.peek());
        this.stack.push(node);
        this.currentNode = node;
        return node;
    }

    private JspNode processEL(char prevChar) throws IOException {
        JspNode node = new JspNode(this.line, this.offset - 2);
        node.setJspNodeType(JspNodeType.EL);
        node.addData(String.valueOf(prevChar) + "{");
        node.setParent(this.stack.peek());
        this.stack.push(node);
        this.currentNode = node;
        return node;
    }

    private Character readChar() throws IOException {
        int c;
        block4: {
            c = 0;
            c = this.jspReader.read();
            if (c != -1) break block4;
            return null;
        }
        ++this.offset;
        this.fileContents.append((char)c);
        this.offsetLineNumberMap.put(this.offset, this.line);
        if ((char)c == '\n') {
            ++this.line;
        }
        return Character.valueOf((char)c);
    }

    public static void main(String[] args) {
        try {
            String name2 = "c:/temp/test.jsp";
            FileInputStream is = new FileInputStream(name2);
            JspParser parser = new JspParser(is, name2);
            List<JspNode> nodes = parser.getJSPNodes();
            for (JspNode jspNode : nodes) {
                System.out.println((Object)((Object)jspNode.getJspNodeType()) + " data:" + jspNode.getData());
                if (jspNode.getJspNodeType().equals((Object)JspNodeType.END_NODE)) {
                    System.out.println("EN: parent: " + jspNode.getParent().getData());
                }
                for (JspNode child : jspNode.getChildren()) {
                    System.out.println("CHILD: " + (Object)((Object)child.getJspNodeType()) + " data:" + child.getData());
                }
                System.out.println("***********************************");
            }
            is.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

