/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.appconversion.jsp.core.model;

import com.ibm.ws.appconversion.jsp.core.model.AttributeValueInfo;
import com.ibm.ws.appconversion.jsp.core.model.ContentTypeInfo;
import com.ibm.ws.appconversion.jsp.core.model.DynamicIncludeInfo;
import com.ibm.ws.appconversion.jsp.core.model.JspImport;
import com.ibm.ws.appconversion.jsp.core.model.JspNode;
import com.ibm.ws.appconversion.jsp.core.model.JspNodeType;
import com.ibm.ws.appconversion.jsp.core.model.PageEncodingInfo;
import com.ibm.ws.appconversion.jsp.core.model.TagIndex;
import com.ibm.ws.appconversion.jsp.core.model.TagLibInfo;
import java.util.StringTokenizer;

public class CoreJspNodeModelMapper {
    public static DynamicIncludeInfo getDynamicIncludeInfo(JspNode jspNode) {
        DynamicIncludeInfo dynamicIncludeInfo = new DynamicIncludeInfo();
        if (!jspNode.getData().contains("<jsp:include") && jspNode.getData().contains("page")) {
            return dynamicIncludeInfo;
        }
        String nodeData = null;
        if (jspNode.getChildren().isEmpty()) {
            nodeData = jspNode.getData();
        } else {
            String childData = jspNode.getChildren().get(0).getData();
            int idx = jspNode.getData().indexOf(childData);
            nodeData = idx > -1 ? jspNode.getData().substring(0, idx) : jspNode.getData();
        }
        AttributeValueInfo pageAttInfo = CoreJspNodeModelMapper.getAttributeValue("page", nodeData);
        dynamicIncludeInfo.setPage(pageAttInfo.getValue());
        dynamicIncludeInfo.setQuote(pageAttInfo.getQuote());
        dynamicIncludeInfo.setStartingPosition(pageAttInfo.getStartPosition());
        return dynamicIncludeInfo;
    }

    public static PageEncodingInfo getPageEncodingInfo(JspNode jspNode) {
        PageEncodingInfo pageEncodingInfo = new PageEncodingInfo();
        if (!jspNode.getData().contains("pageEncoding")) {
            return pageEncodingInfo;
        }
        AttributeValueInfo attValueInfo = CoreJspNodeModelMapper.getAttributeValue("pageEncoding", jspNode.getData());
        if (attValueInfo.getValue() == null) {
            return pageEncodingInfo;
        }
        pageEncodingInfo.setQuote(attValueInfo.getQuote());
        pageEncodingInfo.setStartPosition(attValueInfo.getStartPosition());
        pageEncodingInfo.setValue(attValueInfo.getValue());
        return pageEncodingInfo;
    }

    public static ContentTypeInfo getContentTypeInfo(JspNode jspNode) {
        ContentTypeInfo contentTypeInfo = new ContentTypeInfo();
        if (!jspNode.getData().contains("contentType")) {
            return contentTypeInfo;
        }
        AttributeValueInfo attValInfo = CoreJspNodeModelMapper.getAttributeValue("contentType", jspNode.getData());
        String contentTypeFull = CoreJspNodeModelMapper.getAttributeValue("contentType", jspNode.getData()).getValue();
        if (contentTypeFull == null) {
            return contentTypeInfo;
        }
        contentTypeInfo.setStartPosition(attValInfo.getStartPosition());
        contentTypeInfo.setQuote(attValInfo.getQuote());
        int idx = contentTypeFull.indexOf(59);
        if (idx < 0) {
            contentTypeInfo.setMimeType(contentTypeFull);
            return contentTypeInfo;
        }
        contentTypeInfo.setMimeType(contentTypeFull.substring(0, idx));
        if (contentTypeFull.length() > idx + 1) {
            String charset = contentTypeFull.substring(idx + 1).trim();
            if (charset.contains("charset") && charset.contains("=")) {
                int eqaulIdx = charset.indexOf(61);
                contentTypeInfo.setCharset(charset.substring(eqaulIdx + 1));
            } else {
                contentTypeInfo.setCharset(null);
            }
        }
        return contentTypeInfo;
    }

    public static TagIndex getTagIndex(JspNode jspNode) {
        if (JspNodeType.HTML_ACTION.equals((Object)jspNode.getJspNodeType()) || JspNodeType.JSP_ACTION.equals((Object)jspNode.getJspNodeType())) {
            if (jspNode.getChildren().isEmpty()) {
                TagIndex ti = new TagIndex(jspNode.getData(), jspNode.getOffset(), jspNode.getLine());
                return ti;
            }
            String childData = jspNode.getChildren().get(0).getData();
            int idx = jspNode.getData().indexOf(childData);
            String nodeData = "";
            nodeData = idx > -1 ? jspNode.getData().substring(0, idx) : jspNode.getData();
            TagIndex ti = new TagIndex(nodeData, jspNode.getOffset(), jspNode.getLine());
            return ti;
        }
        return null;
    }

    public static TagLibInfo getTagLibInfo(JspNode jspNode) {
        String data = jspNode.getData();
        TagLibInfo tli = null;
        if (data.contains("taglib") && data.contains("prefix") && data.contains("uri")) {
            String prefix = CoreJspNodeModelMapper.getAttributeValue("prefix", data).getValue();
            if (prefix == null) {
                return null;
            }
            String uri = CoreJspNodeModelMapper.getAttributeValue("uri", data).getValue();
            if (uri == null) {
                return null;
            }
            tli = new TagLibInfo(prefix, uri, jspNode);
        }
        return tli;
    }

    public static JspImport getImportInfo(JspNode jspNode) {
        JspImport jspImport = new JspImport();
        String val = CoreJspNodeModelMapper.getAttributeValue("import", jspNode.getData()).getValue();
        if (val == null) {
            return jspImport;
        }
        StringTokenizer st = new StringTokenizer(val, ",");
        while (st.hasMoreTokens()) {
            jspImport.addImport(st.nextToken());
        }
        return jspImport;
    }

    public static AttributeValueInfo getAttributeValue(String attName, String data) {
        String quote;
        AttributeValueInfo result = new AttributeValueInfo();
        int attIdx = data.indexOf(attName);
        if (attIdx == -1) {
            return result;
        }
        int attEqualSignIdx = data.indexOf(61, attIdx);
        if (attEqualSignIdx == -1) {
            return result;
        }
        int attStartQuoteIdx = -1;
        int doubleQuoteIdx = data.indexOf(34, attEqualSignIdx);
        int singleQuoteIdx = data.indexOf(39, attEqualSignIdx);
        if (doubleQuoteIdx > -1 && singleQuoteIdx > -1) {
            if (doubleQuoteIdx < singleQuoteIdx) {
                quote = "\"";
                attStartQuoteIdx = doubleQuoteIdx;
            } else {
                quote = "'";
                attStartQuoteIdx = singleQuoteIdx;
            }
        } else if (doubleQuoteIdx > -1 && singleQuoteIdx == -1) {
            quote = "\"";
            attStartQuoteIdx = doubleQuoteIdx;
        } else if (doubleQuoteIdx == -1 && singleQuoteIdx > -1) {
            quote = "'";
            attStartQuoteIdx = singleQuoteIdx;
        } else {
            return result;
        }
        int attEndQuoteIdx = data.indexOf(quote, attStartQuoteIdx + 1);
        if (attEndQuoteIdx == -1) {
            return result;
        }
        String attVal = data.substring(attStartQuoteIdx + 1, attEndQuoteIdx);
        result.setAttName(attName);
        result.setValue(attVal);
        result.setStartPosition(attStartQuoteIdx);
        result.setQuote(quote);
        return result;
    }
}

