/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.appserver.tools.jaxrpc.common;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class WsdlDocumentElement {
    private WsdlDocumentElement parent;
    protected String namespace;
    protected String elementType;
    protected Location location;
    protected HashSet<String> declaredNamespaces;
    private HashMap<String, String> attributesMap;
    private HashMap<String, WsdlDocumentElement> partsMap;
    private HashSet<WsdlDocumentElement> elementsSet;
    private boolean hasComplexType = false;
    private String[] verifyElementTypes;

    public WsdlDocumentElement(XMLEvent event) {
        StartElement se = event.asStartElement();
        QName qname = se.getName();
        this.namespace = qname.getNamespaceURI();
        this.elementType = qname.getLocalPart();
        this.location = se.getLocation();
        this.storeAttributes(se.getAttributes());
        this.storeDeclaredNamespaces(se.getNamespaces());
    }

    public WsdlDocumentElement(String namespace, String ... elementTypes) {
        this.namespace = namespace;
        this.verifyElementTypes = elementTypes;
    }

    private String[] getVerifiedElementTypes() {
        return this.verifyElementTypes;
    }

    public void setParent(WsdlDocumentElement parent) {
        this.parent = parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public WsdlDocumentElement getParent() {
        return this.parent;
    }

    public WsdlDocumentElement getParent(int levels) {
        if (levels == 0) {
            return this;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getParent(--levels);
    }

    public WsdlDocumentElement getParent(WsdlDocumentElement match) {
        WsdlDocumentElement p = this.getParent();
        if (p == null) {
            return null;
        }
        if (p.matchElement(match.getNamespace(), match.getVerifiedElementTypes())) {
            return p;
        }
        return p.getParent(match);
    }

    public boolean hasAncestor(WsdlDocumentElement match) {
        return this.getParent(match) != null;
    }

    public boolean checkHierarchy(List<WsdlDocumentElement> hierarchy) {
        WsdlDocumentElement p = this.getParent();
        if (p == null) {
            return false;
        }
        for (WsdlDocumentElement vwde : hierarchy) {
            if (p == null) {
                return false;
            }
            if (p.matchElement(vwde.getNamespace(), vwde.getVerifiedElementTypes())) {
                p = p.getParent();
                continue;
            }
            return false;
        }
        return true;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean ofNamespace(String namespace) {
        return this.namespace.equals(namespace);
    }

    public boolean ofNamespaces(String ... namespaces) {
        for (String ns : namespaces) {
            if (!this.ofNamespace(ns)) continue;
            return true;
        }
        return false;
    }

    public String getElementType() {
        return this.elementType;
    }

    public boolean ofElementType(String elementType) {
        return this.elementType.equals(elementType);
    }

    public boolean ofElementTypes(String ... elementTypes) {
        for (String element : elementTypes) {
            if (!this.ofElementType(element)) continue;
            return true;
        }
        return false;
    }

    public boolean matchElement(String namespace, String ... elementTypes) {
        return this.ofNamespace(namespace) && this.ofElementTypes(elementTypes);
    }

    public boolean matchElementMultipleNamespaces(String elementType, String ... namespaces) {
        return this.ofElementType(elementType) && this.ofNamespaces(namespaces);
    }

    public Location getLocation() {
        return this.location;
    }

    public String showLocation() {
        return MessageFormat.format("\n\t:: Located at ({0}, {1}) in {2}", this.location.getLineNumber(), this.location.getColumnNumber(), this.location.getSystemId());
    }

    private void storeAttributes(Iterator<Attribute> iter) {
        this.attributesMap = new HashMap();
        while (iter.hasNext()) {
            Attribute attribute = iter.next();
            this.attributesMap.put(attribute.getName().getLocalPart(), attribute.getValue());
        }
    }

    public HashMap<String, String> getAttributes() {
        return this.attributesMap;
    }

    public boolean hasAttribute(String attributeName) {
        return this.attributesMap.containsKey(attributeName);
    }

    public String getAttributeValue(String attributeName) {
        return this.attributesMap.get(attributeName);
    }

    public boolean verifyAttribute(String attributeName, String verifyAttributeValue) {
        String attributeValue = this.attributesMap.get(attributeName);
        return attributeValue == null ? false : attributeValue.equals(verifyAttributeValue);
    }

    private void storeDeclaredNamespaces(Iterator<Namespace> iter) {
        this.declaredNamespaces = new HashSet();
        while (iter.hasNext()) {
            Namespace ns = iter.next();
            this.declaredNamespaces.add(ns.getNamespaceURI());
        }
    }

    public boolean hasDeclaredNamespace(String ns) {
        return this.declaredNamespaces.contains(ns) || this.verifyAttribute("targetNamespace", ns);
    }

    public String toString() {
        return "<" + this.getNamespace() + ":" + this.getElementType() + ">";
    }

    public HashMap<String, WsdlDocumentElement> getPartsMap() {
        return this.partsMap;
    }

    public void putPart(String part, WsdlDocumentElement wde) {
        if (this.partsMap == null) {
            this.partsMap = new HashMap();
        }
        this.partsMap.put(part, wde);
    }

    public void removePart(String part) {
        this.partsMap.remove(part);
    }

    public boolean containsPart(String part) {
        if (this.partsMap == null) {
            return false;
        }
        return this.partsMap.containsKey(part);
    }

    public boolean hasComplexType() {
        return this.hasComplexType;
    }

    public void setHasComplexType() {
        this.hasComplexType = true;
    }

    public boolean isParentElement() {
        return this.elementsSet != null;
    }

    public HashSet<WsdlDocumentElement> getElementsSet() {
        return this.elementsSet;
    }

    public void addChildElement(WsdlDocumentElement wde) {
        if (this.elementsSet == null) {
            this.elementsSet = new HashSet();
        }
        this.elementsSet.add(wde);
    }
}

