/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.appserver.tools.jaxrpc.common;

import com.ibm.websphere.appserver.tools.jaxrpc.common.WSDLValidationResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class WSDLValidationResults {
    private String archiveName;
    private String archivePath;
    private Boolean isValid;
    private List<WSDLValidationResult> passResults = new ArrayList<WSDLValidationResult>();
    private List<WSDLValidationResult> failResults = new ArrayList<WSDLValidationResult>();
    private List<String> warnMsgList;
    private List<String> errMsgList;

    public WSDLValidationResults(File archiveFile, List<String> warnMsgList, List<String> errMsgList) throws IOException {
        this.archiveName = archiveFile.getName();
        this.archivePath = archiveFile.getCanonicalPath();
        this.warnMsgList = warnMsgList;
        this.errMsgList = errMsgList;
        this.isValid = errMsgList.isEmpty();
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public String getArchivePath() {
        return this.archivePath;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void addWSDLValidationResult(WSDLValidationResult result) {
        if (result.isWsdlValid()) {
            this.passResults.add(result);
        } else {
            result.setWsdlInvalid();
            this.failResults.add(result);
            this.isValid = false;
        }
    }

    public int getPassCount() {
        return this.passResults.size();
    }

    public int getFailCount() {
        return this.failResults.size();
    }

    public int getTotalCount() {
        return this.passResults.size() + this.failResults.size();
    }

    public List<WSDLValidationResult> getPassResults() {
        return this.passResults;
    }

    public List<WSDLValidationResult> getFailResults() {
        return this.failResults;
    }

    public List<String> getWarnMessages() {
        return this.warnMsgList;
    }

    public List<String> getErrorMessages() {
        return this.errMsgList;
    }
}

