/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.text_to_speech.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class Word
extends GenericModel {
    protected String word;
    protected String translation;
    @SerializedName(value="part_of_speech")
    protected String partOfSpeech;

    protected Word(Builder builder) {
        Validator.notNull((Object)builder.word, (String)"word cannot be null");
        Validator.notNull((Object)builder.translation, (String)"translation cannot be null");
        this.word = builder.word;
        this.translation = builder.translation;
        this.partOfSpeech = builder.partOfSpeech;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String word() {
        return this.word;
    }

    public String translation() {
        return this.translation;
    }

    public String partOfSpeech() {
        return this.partOfSpeech;
    }

    public static class Builder {
        private String word;
        private String translation;
        private String partOfSpeech;

        private Builder(Word word) {
            this.word = word.word;
            this.translation = word.translation;
            this.partOfSpeech = word.partOfSpeech;
        }

        public Builder() {
        }

        public Builder(String word, String translation) {
            this.word = word;
            this.translation = translation;
        }

        public Word build() {
            return new Word(this);
        }

        public Builder word(String word) {
            this.word = word;
            return this;
        }

        public Builder translation(String translation) {
            this.translation = translation;
            return this;
        }

        public Builder partOfSpeech(String partOfSpeech) {
            this.partOfSpeech = partOfSpeech;
            return this;
        }
    }

    public static interface PartOfSpeech {
        public static final String DOSI = "Dosi";
        public static final String FUKU = "Fuku";
        public static final String GOBI = "Gobi";
        public static final String HOKA = "Hoka";
        public static final String JODO = "Jodo";
        public static final String JOSI = "Josi";
        public static final String KATO = "Kato";
        public static final String KEDO = "Kedo";
        public static final String KEYO = "Keyo";
        public static final String KIGO = "Kigo";
        public static final String KOYU = "Koyu";
        public static final String MESI = "Mesi";
        public static final String RETA = "Reta";
        public static final String STBI = "Stbi";
        public static final String STTO = "Stto";
        public static final String STZO = "Stzo";
        public static final String SUJI = "Suji";
    }
}

