/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.text_to_speech.v1;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.common.SdkCommon;
import com.ibm.watson.text_to_speech.v1.model.AddWordOptions;
import com.ibm.watson.text_to_speech.v1.model.AddWordsOptions;
import com.ibm.watson.text_to_speech.v1.model.CreateVoiceModelOptions;
import com.ibm.watson.text_to_speech.v1.model.DeleteUserDataOptions;
import com.ibm.watson.text_to_speech.v1.model.DeleteVoiceModelOptions;
import com.ibm.watson.text_to_speech.v1.model.DeleteWordOptions;
import com.ibm.watson.text_to_speech.v1.model.GetPronunciationOptions;
import com.ibm.watson.text_to_speech.v1.model.GetVoiceModelOptions;
import com.ibm.watson.text_to_speech.v1.model.GetVoiceOptions;
import com.ibm.watson.text_to_speech.v1.model.GetWordOptions;
import com.ibm.watson.text_to_speech.v1.model.ListVoiceModelsOptions;
import com.ibm.watson.text_to_speech.v1.model.ListVoicesOptions;
import com.ibm.watson.text_to_speech.v1.model.ListWordsOptions;
import com.ibm.watson.text_to_speech.v1.model.Pronunciation;
import com.ibm.watson.text_to_speech.v1.model.SynthesizeOptions;
import com.ibm.watson.text_to_speech.v1.model.Translation;
import com.ibm.watson.text_to_speech.v1.model.UpdateVoiceModelOptions;
import com.ibm.watson.text_to_speech.v1.model.Voice;
import com.ibm.watson.text_to_speech.v1.model.VoiceModel;
import com.ibm.watson.text_to_speech.v1.model.VoiceModels;
import com.ibm.watson.text_to_speech.v1.model.Voices;
import com.ibm.watson.text_to_speech.v1.model.Words;
import com.ibm.watson.text_to_speech.v1.websocket.SynthesizeCallback;
import com.ibm.watson.text_to_speech.v1.websocket.TextToSpeechWebSocketListener;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

public class TextToSpeech
extends BaseService {
    private static final String DEFAULT_SERVICE_NAME = "text_to_speech";
    private static final String DEFAULT_SERVICE_URL = "https://stream.watsonplatform.net/text-to-speech/api";

    public TextToSpeech() {
        this(DEFAULT_SERVICE_NAME, ConfigBasedAuthenticatorFactory.getAuthenticator((String)DEFAULT_SERVICE_NAME));
    }

    public TextToSpeech(Authenticator authenticator) {
        this(DEFAULT_SERVICE_NAME, authenticator);
    }

    public TextToSpeech(String serviceName) {
        this(serviceName, ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName));
    }

    public TextToSpeech(String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
        this.configureService(serviceName);
    }

    public ServiceCall<Voices> listVoices(ListVoicesOptions listVoicesOptions) {
        String[] pathSegments = new String[]{"v1/voices"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listVoices");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listVoicesOptions != null) {
            // empty if block
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Voices>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Voices> listVoices() {
        return this.listVoices(null);
    }

    public ServiceCall<Voice> getVoice(GetVoiceOptions getVoiceOptions) {
        Validator.notNull((Object)((Object)getVoiceOptions), (String)"getVoiceOptions cannot be null");
        String[] pathSegments = new String[]{"v1/voices"};
        String[] pathParameters = new String[]{getVoiceOptions.voice()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getVoice");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getVoiceOptions.customizationId() != null) {
            builder.query(new Object[]{"customization_id", getVoiceOptions.customizationId()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Voice>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> synthesize(SynthesizeOptions synthesizeOptions) {
        Validator.notNull((Object)((Object)synthesizeOptions), (String)"synthesizeOptions cannot be null");
        String[] pathSegments = new String[]{"v1/synthesize"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"synthesize");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        if (synthesizeOptions.accept() != null) {
            builder.header(new Object[]{"Accept", synthesizeOptions.accept()});
        }
        if (synthesizeOptions.voice() != null) {
            builder.query(new Object[]{"voice", synthesizeOptions.voice()});
        }
        if (synthesizeOptions.customizationId() != null) {
            builder.query(new Object[]{"customization_id", synthesizeOptions.customizationId()});
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("text", synthesizeOptions.text());
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public WebSocket synthesizeUsingWebSocket(SynthesizeOptions synthesizeOptions, SynthesizeCallback callback) {
        Validator.notNull((Object)((Object)synthesizeOptions), (String)"synthesizeOptions cannot be null");
        Validator.notNull((Object)callback, (String)"callback cannot be null");
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)(this.getServiceUrl() + "/v1/synthesize")).newBuilder();
        if (synthesizeOptions.voice() != null) {
            urlBuilder.addQueryParameter("voice", synthesizeOptions.voice());
        }
        if (synthesizeOptions.customizationId() != null) {
            urlBuilder.addQueryParameter("customization_id", synthesizeOptions.customizationId());
        }
        String url = urlBuilder.toString().replace("https://", "wss://");
        Request.Builder builder = new Request.Builder().url(url);
        this.setAuthentication(builder);
        this.setDefaultHeaders(builder);
        OkHttpClient client = this.configureHttpClient();
        return client.newWebSocket(builder.build(), (WebSocketListener)new TextToSpeechWebSocketListener(synthesizeOptions, callback));
    }

    public ServiceCall<Pronunciation> getPronunciation(GetPronunciationOptions getPronunciationOptions) {
        Validator.notNull((Object)((Object)getPronunciationOptions), (String)"getPronunciationOptions cannot be null");
        String[] pathSegments = new String[]{"v1/pronunciation"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getPronunciation");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"text", getPronunciationOptions.text()});
        if (getPronunciationOptions.voice() != null) {
            builder.query(new Object[]{"voice", getPronunciationOptions.voice()});
        }
        if (getPronunciationOptions.format() != null) {
            builder.query(new Object[]{"format", getPronunciationOptions.format()});
        }
        if (getPronunciationOptions.customizationId() != null) {
            builder.query(new Object[]{"customization_id", getPronunciationOptions.customizationId()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Pronunciation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<VoiceModel> createVoiceModel(CreateVoiceModelOptions createVoiceModelOptions) {
        Validator.notNull((Object)((Object)createVoiceModelOptions), (String)"createVoiceModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"createVoiceModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", createVoiceModelOptions.name());
        if (createVoiceModelOptions.language() != null) {
            contentJson.addProperty("language", createVoiceModelOptions.language());
        }
        if (createVoiceModelOptions.description() != null) {
            contentJson.addProperty("description", createVoiceModelOptions.description());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<VoiceModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<VoiceModels> listVoiceModels(ListVoiceModelsOptions listVoiceModelsOptions) {
        String[] pathSegments = new String[]{"v1/customizations"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listVoiceModels");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listVoiceModelsOptions != null && listVoiceModelsOptions.language() != null) {
            builder.query(new Object[]{"language", listVoiceModelsOptions.language()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<VoiceModels>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<VoiceModels> listVoiceModels() {
        return this.listVoiceModels(null);
    }

    public ServiceCall<Void> updateVoiceModel(UpdateVoiceModelOptions updateVoiceModelOptions) {
        Validator.notNull((Object)((Object)updateVoiceModelOptions), (String)"updateVoiceModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations"};
        String[] pathParameters = new String[]{updateVoiceModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"updateVoiceModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (updateVoiceModelOptions.name() != null) {
            contentJson.addProperty("name", updateVoiceModelOptions.name());
        }
        if (updateVoiceModelOptions.description() != null) {
            contentJson.addProperty("description", updateVoiceModelOptions.description());
        }
        if (updateVoiceModelOptions.words() != null) {
            contentJson.add("words", GsonSingleton.getGson().toJsonTree(updateVoiceModelOptions.words()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<VoiceModel> getVoiceModel(GetVoiceModelOptions getVoiceModelOptions) {
        Validator.notNull((Object)((Object)getVoiceModelOptions), (String)"getVoiceModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations"};
        String[] pathParameters = new String[]{getVoiceModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getVoiceModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<VoiceModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteVoiceModel(DeleteVoiceModelOptions deleteVoiceModelOptions) {
        Validator.notNull((Object)((Object)deleteVoiceModelOptions), (String)"deleteVoiceModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations"};
        String[] pathParameters = new String[]{deleteVoiceModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteVoiceModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> addWords(AddWordsOptions addWordsOptions) {
        Validator.notNull((Object)((Object)addWordsOptions), (String)"addWordsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "words"};
        String[] pathParameters = new String[]{addWordsOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"addWords");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.add("words", GsonSingleton.getGson().toJsonTree(addWordsOptions.words()));
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Words> listWords(ListWordsOptions listWordsOptions) {
        Validator.notNull((Object)((Object)listWordsOptions), (String)"listWordsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "words"};
        String[] pathParameters = new String[]{listWordsOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listWords");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Words>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> addWord(AddWordOptions addWordOptions) {
        Validator.notNull((Object)((Object)addWordOptions), (String)"addWordOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "words"};
        String[] pathParameters = new String[]{addWordOptions.customizationId(), addWordOptions.word()};
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"addWord");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("translation", addWordOptions.translation());
        if (addWordOptions.partOfSpeech() != null) {
            contentJson.addProperty("part_of_speech", addWordOptions.partOfSpeech());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Translation> getWord(GetWordOptions getWordOptions) {
        Validator.notNull((Object)((Object)getWordOptions), (String)"getWordOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "words"};
        String[] pathParameters = new String[]{getWordOptions.customizationId(), getWordOptions.word()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getWord");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Translation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteWord(DeleteWordOptions deleteWordOptions) {
        Validator.notNull((Object)((Object)deleteWordOptions), (String)"deleteWordOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "words"};
        String[] pathParameters = new String[]{deleteWordOptions.customizationId(), deleteWordOptions.word()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteWord");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteUserData(DeleteUserDataOptions deleteUserDataOptions) {
        Validator.notNull((Object)((Object)deleteUserDataOptions), (String)"deleteUserDataOptions cannot be null");
        String[] pathSegments = new String[]{"v1/user_data"};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteUserData");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.query(new Object[]{"customer_id", deleteUserDataOptions.customerId()});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

