/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.swr.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class UserAuth {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="user_id")
    private String userId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="user_name")
    private String userName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="auth")
    private AuthEnum auth;

    public UserAuth withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public UserAuth withUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public UserAuth withAuth(AuthEnum auth) {
        this.auth = auth;
        return this;
    }

    public AuthEnum getAuth() {
        return this.auth;
    }

    public void setAuth(AuthEnum auth) {
        this.auth = auth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAuth userAuth = (UserAuth)o;
        return Objects.equals(this.userId, userAuth.userId) && Objects.equals(this.userName, userAuth.userName) && Objects.equals(this.auth, userAuth.auth);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.userName, this.auth);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserAuth {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    auth: ").append(this.toIndentedString(this.auth)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class AuthEnum {
        public static final AuthEnum NUMBER_7 = new AuthEnum(7L);
        public static final AuthEnum NUMBER_3 = new AuthEnum(3L);
        public static final AuthEnum NUMBER_1 = new AuthEnum(1L);
        private static final Map<Long, AuthEnum> STATIC_FIELDS = AuthEnum.createStaticFields();
        private Long value;

        private static Map<Long, AuthEnum> createStaticFields() {
            HashMap<Long, AuthEnum> map = new HashMap<Long, AuthEnum>();
            map.put(7L, NUMBER_7);
            map.put(3L, NUMBER_3);
            map.put(1L, NUMBER_1);
            return Collections.unmodifiableMap(map);
        }

        AuthEnum(Long value) {
            this.value = value;
        }

        @JsonValue
        public Long getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AuthEnum fromValue(Long value) {
            if (value == null) {
                return null;
            }
            AuthEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new AuthEnum(value);
            }
            return result;
        }

        public static AuthEnum valueOf(Long value) {
            if (value == null) {
                return null;
            }
            AuthEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof AuthEnum) {
                return this.value.equals(((AuthEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

