/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.swr.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.swr.v2.model.TagSelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Rule {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="template")
    private TemplateEnum template;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="params")
    private Object params;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="tag_selectors")
    private List<TagSelector> tagSelectors = null;

    public Rule withTemplate(TemplateEnum template) {
        this.template = template;
        return this;
    }

    public TemplateEnum getTemplate() {
        return this.template;
    }

    public void setTemplate(TemplateEnum template) {
        this.template = template;
    }

    public Rule withParams(Object params) {
        this.params = params;
        return this;
    }

    public Object getParams() {
        return this.params;
    }

    public void setParams(Object params) {
        this.params = params;
    }

    public Rule withTagSelectors(List<TagSelector> tagSelectors) {
        this.tagSelectors = tagSelectors;
        return this;
    }

    public Rule addTagSelectorsItem(TagSelector tagSelectorsItem) {
        if (this.tagSelectors == null) {
            this.tagSelectors = new ArrayList<TagSelector>();
        }
        this.tagSelectors.add(tagSelectorsItem);
        return this;
    }

    public Rule withTagSelectors(Consumer<List<TagSelector>> tagSelectorsSetter) {
        if (this.tagSelectors == null) {
            this.tagSelectors = new ArrayList<TagSelector>();
        }
        tagSelectorsSetter.accept(this.tagSelectors);
        return this;
    }

    public List<TagSelector> getTagSelectors() {
        return this.tagSelectors;
    }

    public void setTagSelectors(List<TagSelector> tagSelectors) {
        this.tagSelectors = tagSelectors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        return Objects.equals(this.template, rule.template) && Objects.equals(this.params, rule.params) && Objects.equals(this.tagSelectors, rule.tagSelectors);
    }

    public int hashCode() {
        return Objects.hash(this.template, this.params, this.tagSelectors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Rule {\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    params: ").append(this.toIndentedString(this.params)).append("\n");
        sb.append("    tagSelectors: ").append(this.toIndentedString(this.tagSelectors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class TemplateEnum {
        public static final TemplateEnum DATE_RULE = new TemplateEnum("date_rule");
        public static final TemplateEnum TAG_RULE = new TemplateEnum("tag_rule");
        private static final Map<String, TemplateEnum> STATIC_FIELDS = TemplateEnum.createStaticFields();
        private String value;

        private static Map<String, TemplateEnum> createStaticFields() {
            HashMap<String, TemplateEnum> map = new HashMap<String, TemplateEnum>();
            map.put("date_rule", DATE_RULE);
            map.put("tag_rule", TAG_RULE);
            return Collections.unmodifiableMap(map);
        }

        TemplateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TemplateEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            TemplateEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new TemplateEnum(value);
            }
            return result;
        }

        public static TemplateEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            TemplateEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof TemplateEnum) {
                return this.value.equals(((TemplateEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

