/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.swr.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CreateRepoRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="repository")
    private String repository;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="is_public")
    private Boolean isPublic;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="category")
    private CategoryEnum category;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="description")
    private String description;

    public CreateRepoRequestBody withRepository(String repository) {
        this.repository = repository;
        return this;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public CreateRepoRequestBody withIsPublic(Boolean isPublic) {
        this.isPublic = isPublic;
        return this;
    }

    public Boolean getIsPublic() {
        return this.isPublic;
    }

    public void setIsPublic(Boolean isPublic) {
        this.isPublic = isPublic;
    }

    public CreateRepoRequestBody withCategory(CategoryEnum category) {
        this.category = category;
        return this;
    }

    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public CreateRepoRequestBody withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateRepoRequestBody createRepoRequestBody = (CreateRepoRequestBody)o;
        return Objects.equals(this.repository, createRepoRequestBody.repository) && Objects.equals(this.isPublic, createRepoRequestBody.isPublic) && Objects.equals(this.category, createRepoRequestBody.category) && Objects.equals(this.description, createRepoRequestBody.description);
    }

    public int hashCode() {
        return Objects.hash(this.repository, this.isPublic, this.category, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateRepoRequestBody {\n");
        sb.append("    repository: ").append(this.toIndentedString(this.repository)).append("\n");
        sb.append("    isPublic: ").append(this.toIndentedString(this.isPublic)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class CategoryEnum {
        public static final CategoryEnum APP_SERVER = new CategoryEnum("app_server");
        public static final CategoryEnum LINUX = new CategoryEnum("linux");
        public static final CategoryEnum FRAMEWORK_APP = new CategoryEnum("framework_app");
        public static final CategoryEnum DATABASE = new CategoryEnum("database");
        public static final CategoryEnum LANG = new CategoryEnum("lang");
        public static final CategoryEnum WINDOWS = new CategoryEnum("windows");
        public static final CategoryEnum ARMS = new CategoryEnum("arms");
        public static final CategoryEnum OTHER = new CategoryEnum("other");
        private static final Map<String, CategoryEnum> STATIC_FIELDS = CategoryEnum.createStaticFields();
        private String value;

        private static Map<String, CategoryEnum> createStaticFields() {
            HashMap<String, CategoryEnum> map = new HashMap<String, CategoryEnum>();
            map.put("app_server", APP_SERVER);
            map.put("linux", LINUX);
            map.put("framework_app", FRAMEWORK_APP);
            map.put("database", DATABASE);
            map.put("lang", LANG);
            map.put("windows", WINDOWS);
            map.put("arms", ARMS);
            map.put("other", OTHER);
            return Collections.unmodifiableMap(map);
        }

        CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            CategoryEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new CategoryEnum(value);
            }
            return result;
        }

        public static CategoryEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            CategoryEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof CategoryEnum) {
                return this.value.equals(((CategoryEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

