/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.rds.v3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.huaweicloud.sdk.rds.v3.model.ParaGroupDatastore;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ConfigurationForCreation {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="name")
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="description")
    private String description;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="datastore")
    private ParaGroupDatastore datastore;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="values")
    private Map<String, String> values = null;

    public ConfigurationForCreation withName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ConfigurationForCreation withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ConfigurationForCreation withDatastore(ParaGroupDatastore datastore) {
        this.datastore = datastore;
        return this;
    }

    public ConfigurationForCreation withDatastore(Consumer<ParaGroupDatastore> datastoreSetter) {
        if (this.datastore == null) {
            this.datastore = new ParaGroupDatastore();
            datastoreSetter.accept(this.datastore);
        }
        return this;
    }

    public ParaGroupDatastore getDatastore() {
        return this.datastore;
    }

    public void setDatastore(ParaGroupDatastore datastore) {
        this.datastore = datastore;
    }

    public ConfigurationForCreation withValues(Map<String, String> values) {
        this.values = values;
        return this;
    }

    public ConfigurationForCreation putValuesItem(String key, String valuesItem) {
        if (this.values == null) {
            this.values = new HashMap<String, String>();
        }
        this.values.put(key, valuesItem);
        return this;
    }

    public ConfigurationForCreation withValues(Consumer<Map<String, String>> valuesSetter) {
        if (this.values == null) {
            this.values = new HashMap<String, String>();
        }
        valuesSetter.accept(this.values);
        return this;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public void setValues(Map<String, String> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationForCreation configurationForCreation = (ConfigurationForCreation)o;
        return Objects.equals(this.name, configurationForCreation.name) && Objects.equals(this.description, configurationForCreation.description) && Objects.equals(this.datastore, configurationForCreation.datastore) && Objects.equals(this.values, configurationForCreation.values);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.datastore, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConfigurationForCreation {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    datastore: ").append(this.toIndentedString(this.datastore)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

