/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.cse.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.cse.v1.model.SpecClusterNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Spec {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="id")
    private Long id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="engine_id")
    private String engineId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="spec_type")
    private SpecTypeEnum specType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="cluster")
    private String cluster;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="cluster_id")
    private String clusterId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="cluster_nodes")
    private SpecClusterNode clusterNodes;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="flavor")
    private String flavor;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="region")
    private String region;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="version")
    private String version;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="extend_param")
    private String extendParam;

    public Spec withId(Long id) {
        this.id = id;
        return this;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Spec withEngineId(String engineId) {
        this.engineId = engineId;
        return this;
    }

    public String getEngineId() {
        return this.engineId;
    }

    public void setEngineId(String engineId) {
        this.engineId = engineId;
    }

    public Spec withSpecType(SpecTypeEnum specType) {
        this.specType = specType;
        return this;
    }

    public SpecTypeEnum getSpecType() {
        return this.specType;
    }

    public void setSpecType(SpecTypeEnum specType) {
        this.specType = specType;
    }

    public Spec withCluster(String cluster) {
        this.cluster = cluster;
        return this;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public Spec withClusterId(String clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public Spec withClusterNodes(SpecClusterNode clusterNodes) {
        this.clusterNodes = clusterNodes;
        return this;
    }

    public Spec withClusterNodes(Consumer<SpecClusterNode> clusterNodesSetter) {
        if (this.clusterNodes == null) {
            this.clusterNodes = new SpecClusterNode();
            clusterNodesSetter.accept(this.clusterNodes);
        }
        return this;
    }

    public SpecClusterNode getClusterNodes() {
        return this.clusterNodes;
    }

    public void setClusterNodes(SpecClusterNode clusterNodes) {
        this.clusterNodes = clusterNodes;
    }

    public Spec withFlavor(String flavor) {
        this.flavor = flavor;
        return this;
    }

    public String getFlavor() {
        return this.flavor;
    }

    public void setFlavor(String flavor) {
        this.flavor = flavor;
    }

    public Spec withRegion(String region) {
        this.region = region;
        return this;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Spec withVersion(String version) {
        this.version = version;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Spec withExtendParam(String extendParam) {
        this.extendParam = extendParam;
        return this;
    }

    public String getExtendParam() {
        return this.extendParam;
    }

    public void setExtendParam(String extendParam) {
        this.extendParam = extendParam;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Spec spec = (Spec)o;
        return Objects.equals(this.id, spec.id) && Objects.equals(this.engineId, spec.engineId) && Objects.equals(this.specType, spec.specType) && Objects.equals(this.cluster, spec.cluster) && Objects.equals(this.clusterId, spec.clusterId) && Objects.equals(this.clusterNodes, spec.clusterNodes) && Objects.equals(this.flavor, spec.flavor) && Objects.equals(this.region, spec.region) && Objects.equals(this.version, spec.version) && Objects.equals(this.extendParam, spec.extendParam);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.engineId, this.specType, this.cluster, this.clusterId, this.clusterNodes, this.flavor, this.region, this.version, this.extendParam);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Spec {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    engineId: ").append(this.toIndentedString(this.engineId)).append("\n");
        sb.append("    specType: ").append(this.toIndentedString(this.specType)).append("\n");
        sb.append("    cluster: ").append(this.toIndentedString(this.cluster)).append("\n");
        sb.append("    clusterId: ").append(this.toIndentedString(this.clusterId)).append("\n");
        sb.append("    clusterNodes: ").append(this.toIndentedString(this.clusterNodes)).append("\n");
        sb.append("    flavor: ").append(this.toIndentedString(this.flavor)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    extendParam: ").append(this.toIndentedString(this.extendParam)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class SpecTypeEnum {
        public static final SpecTypeEnum CCE = new SpecTypeEnum("CCE");
        public static final SpecTypeEnum CSE = new SpecTypeEnum("CSE");
        public static final SpecTypeEnum SPRINGCLOUD = new SpecTypeEnum("SpringCloud");
        private static final Map<String, SpecTypeEnum> STATIC_FIELDS = SpecTypeEnum.createStaticFields();
        private String value;

        private static Map<String, SpecTypeEnum> createStaticFields() {
            HashMap<String, SpecTypeEnum> map = new HashMap<String, SpecTypeEnum>();
            map.put("CCE", CCE);
            map.put("CSE", CSE);
            map.put("SpringCloud", SPRINGCLOUD);
            return Collections.unmodifiableMap(map);
        }

        SpecTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SpecTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            SpecTypeEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new SpecTypeEnum(value);
            }
            return result;
        }

        public static SpecTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            SpecTypeEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof SpecTypeEnum) {
                return this.value.equals(((SpecTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

