/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.cse.v1.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.huaweicloud.sdk.cse.v1.model.EntrypointItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class EngineExternalEntrypoint {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="external_address")
    private String externalAddress;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="public_address")
    private String publicAddress;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="service_endpoint")
    private Map<String, EntrypointItem> serviceEndpoint = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="public_service_endpoint")
    private Map<String, EntrypointItem> publicServiceEndpoint = null;

    public EngineExternalEntrypoint withExternalAddress(String externalAddress) {
        this.externalAddress = externalAddress;
        return this;
    }

    public String getExternalAddress() {
        return this.externalAddress;
    }

    public void setExternalAddress(String externalAddress) {
        this.externalAddress = externalAddress;
    }

    public EngineExternalEntrypoint withPublicAddress(String publicAddress) {
        this.publicAddress = publicAddress;
        return this;
    }

    public String getPublicAddress() {
        return this.publicAddress;
    }

    public void setPublicAddress(String publicAddress) {
        this.publicAddress = publicAddress;
    }

    public EngineExternalEntrypoint withServiceEndpoint(Map<String, EntrypointItem> serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        return this;
    }

    public EngineExternalEntrypoint putServiceEndpointItem(String key, EntrypointItem serviceEndpointItem) {
        if (this.serviceEndpoint == null) {
            this.serviceEndpoint = new HashMap<String, EntrypointItem>();
        }
        this.serviceEndpoint.put(key, serviceEndpointItem);
        return this;
    }

    public EngineExternalEntrypoint withServiceEndpoint(Consumer<Map<String, EntrypointItem>> serviceEndpointSetter) {
        if (this.serviceEndpoint == null) {
            this.serviceEndpoint = new HashMap<String, EntrypointItem>();
        }
        serviceEndpointSetter.accept(this.serviceEndpoint);
        return this;
    }

    public Map<String, EntrypointItem> getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public void setServiceEndpoint(Map<String, EntrypointItem> serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
    }

    public EngineExternalEntrypoint withPublicServiceEndpoint(Map<String, EntrypointItem> publicServiceEndpoint) {
        this.publicServiceEndpoint = publicServiceEndpoint;
        return this;
    }

    public EngineExternalEntrypoint putPublicServiceEndpointItem(String key, EntrypointItem publicServiceEndpointItem) {
        if (this.publicServiceEndpoint == null) {
            this.publicServiceEndpoint = new HashMap<String, EntrypointItem>();
        }
        this.publicServiceEndpoint.put(key, publicServiceEndpointItem);
        return this;
    }

    public EngineExternalEntrypoint withPublicServiceEndpoint(Consumer<Map<String, EntrypointItem>> publicServiceEndpointSetter) {
        if (this.publicServiceEndpoint == null) {
            this.publicServiceEndpoint = new HashMap<String, EntrypointItem>();
        }
        publicServiceEndpointSetter.accept(this.publicServiceEndpoint);
        return this;
    }

    public Map<String, EntrypointItem> getPublicServiceEndpoint() {
        return this.publicServiceEndpoint;
    }

    public void setPublicServiceEndpoint(Map<String, EntrypointItem> publicServiceEndpoint) {
        this.publicServiceEndpoint = publicServiceEndpoint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EngineExternalEntrypoint engineExternalEntrypoint = (EngineExternalEntrypoint)o;
        return Objects.equals(this.externalAddress, engineExternalEntrypoint.externalAddress) && Objects.equals(this.publicAddress, engineExternalEntrypoint.publicAddress) && Objects.equals(this.serviceEndpoint, engineExternalEntrypoint.serviceEndpoint) && Objects.equals(this.publicServiceEndpoint, engineExternalEntrypoint.publicServiceEndpoint);
    }

    public int hashCode() {
        return Objects.hash(this.externalAddress, this.publicAddress, this.serviceEndpoint, this.publicServiceEndpoint);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EngineExternalEntrypoint {\n");
        sb.append("    externalAddress: ").append(this.toIndentedString(this.externalAddress)).append("\n");
        sb.append("    publicAddress: ").append(this.toIndentedString(this.publicAddress)).append("\n");
        sb.append("    serviceEndpoint: ").append(this.toIndentedString(this.serviceEndpoint)).append("\n");
        sb.append("    publicServiceEndpoint: ").append(this.toIndentedString(this.publicServiceEndpoint)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

