/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.cse.v1;

import com.huaweicloud.sdk.core.TypeCasts;
import com.huaweicloud.sdk.core.http.FieldExistence;
import com.huaweicloud.sdk.core.http.HttpMethod;
import com.huaweicloud.sdk.core.http.HttpRequestDef;
import com.huaweicloud.sdk.core.http.LocationType;
import com.huaweicloud.sdk.cse.v1.model.CreateEngineRequest;
import com.huaweicloud.sdk.cse.v1.model.CreateEngineResponse;
import com.huaweicloud.sdk.cse.v1.model.DeleteEngineRequest;
import com.huaweicloud.sdk.cse.v1.model.DeleteEngineResponse;
import com.huaweicloud.sdk.cse.v1.model.DownloadKieReqBody;
import com.huaweicloud.sdk.cse.v1.model.DownloadKieRequest;
import com.huaweicloud.sdk.cse.v1.model.DownloadKieResponse;
import com.huaweicloud.sdk.cse.v1.model.EngineCreateReq;
import com.huaweicloud.sdk.cse.v1.model.ListEnginesRequest;
import com.huaweicloud.sdk.cse.v1.model.ListEnginesResponse;
import com.huaweicloud.sdk.cse.v1.model.ListFlavorsRequest;
import com.huaweicloud.sdk.cse.v1.model.ListFlavorsResponse;
import com.huaweicloud.sdk.cse.v1.model.ShowEngineJobRequest;
import com.huaweicloud.sdk.cse.v1.model.ShowEngineJobResponse;
import com.huaweicloud.sdk.cse.v1.model.ShowEngineRequest;
import com.huaweicloud.sdk.cse.v1.model.ShowEngineResponse;
import com.huaweicloud.sdk.cse.v1.model.UploadKieRequest;
import com.huaweicloud.sdk.cse.v1.model.UploadKieRequestBody;
import com.huaweicloud.sdk.cse.v1.model.UploadKieResponse;

public class CseMeta {
    public static final HttpRequestDef<CreateEngineRequest, CreateEngineResponse> createEngine = CseMeta.genForcreateEngine();
    public static final HttpRequestDef<DeleteEngineRequest, DeleteEngineResponse> deleteEngine = CseMeta.genFordeleteEngine();
    public static final HttpRequestDef<DownloadKieRequest, DownloadKieResponse> downloadKie = CseMeta.genFordownloadKie();
    public static final HttpRequestDef<ListEnginesRequest, ListEnginesResponse> listEngines = CseMeta.genForlistEngines();
    public static final HttpRequestDef<ListFlavorsRequest, ListFlavorsResponse> listFlavors = CseMeta.genForlistFlavors();
    public static final HttpRequestDef<ShowEngineRequest, ShowEngineResponse> showEngine = CseMeta.genForshowEngine();
    public static final HttpRequestDef<ShowEngineJobRequest, ShowEngineJobResponse> showEngineJob = CseMeta.genForshowEngineJob();
    public static final HttpRequestDef<UploadKieRequest, UploadKieResponse> uploadKie = CseMeta.genForuploadKie();

    private static HttpRequestDef<CreateEngineRequest, CreateEngineResponse> genForcreateEngine() {
        HttpRequestDef.Builder builder = HttpRequestDef.builder((HttpMethod)HttpMethod.POST, CreateEngineRequest.class, CreateEngineResponse.class).withName("CreateEngine").withUri("/v2/{project_id}/enginemgr/engines").withContentType("application/json");
        builder.withRequestField("X-Enterprise-Project-ID", LocationType.Header, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(String.class), f -> f.withMarshaller(CreateEngineRequest::getXEnterpriseProjectID, (req, v) -> req.setXEnterpriseProjectID((String)v)));
        builder.withRequestField("body", LocationType.Body, FieldExistence.NON_NULL_NON_EMPTY, (Class)TypeCasts.uncheckedConversion(EngineCreateReq.class), f -> f.withMarshaller(CreateEngineRequest::getBody, (req, v) -> req.setBody((EngineCreateReq)v)));
        return builder.build();
    }

    private static HttpRequestDef<DeleteEngineRequest, DeleteEngineResponse> genFordeleteEngine() {
        HttpRequestDef.Builder builder = HttpRequestDef.builder((HttpMethod)HttpMethod.DELETE, DeleteEngineRequest.class, DeleteEngineResponse.class).withName("DeleteEngine").withUri("/v2/{project_id}/enginemgr/engines/{engine_id}").withContentType("application/json");
        builder.withRequestField("engine_id", LocationType.Path, FieldExistence.NON_NULL_NON_EMPTY, (Class)TypeCasts.uncheckedConversion(String.class), f -> f.withMarshaller(DeleteEngineRequest::getEngineId, (req, v) -> req.setEngineId((String)v)));
        builder.withRequestField("X-Enterprise-Project-ID", LocationType.Header, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(String.class), f -> f.withMarshaller(DeleteEngineRequest::getXEnterpriseProjectID, (req, v) -> req.setXEnterpriseProjectID((String)v)));
        return builder.build();
    }

    private static HttpRequestDef<DownloadKieRequest, DownloadKieResponse> genFordownloadKie() {
        HttpRequestDef.Builder builder = HttpRequestDef.builder((HttpMethod)HttpMethod.POST, DownloadKieRequest.class, DownloadKieResponse.class).withName("DownloadKie").withUri("/v1/{project_id}/kie/download").withContentType("application/json");
        builder.withRequestField("label", LocationType.Query, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(String.class), f -> f.withMarshaller(DownloadKieRequest::getLabel, (req, v) -> req.setLabel((String)v)));
        builder.withRequestField("match", LocationType.Query, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(DownloadKieRequest.MatchEnum.class), f -> f.withMarshaller(DownloadKieRequest::getMatch, (req, v) -> req.setMatch((DownloadKieRequest.MatchEnum)v)));
        builder.withRequestField("X-Enterprise-Project-ID", LocationType.Header, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(String.class), f -> f.withMarshaller(DownloadKieRequest::getXEnterpriseProjectID, (req, v) -> req.setXEnterpriseProjectID((String)v)));
        builder.withRequestField("x-engine-id", LocationType.Header, FieldExistence.NON_NULL_NON_EMPTY, (Class)TypeCasts.uncheckedConversion(String.class), f -> f.withMarshaller(DownloadKieRequest::getXEngineId, (req, v) -> req.setXEngineId((String)v)));
        builder.withRequestField("body", LocationType.Body, FieldExistence.NON_NULL_NON_EMPTY, (Class)TypeCasts.uncheckedConversion(DownloadKieReqBody.class), f -> f.withMarshaller(DownloadKieRequest::getBody, (req, v) -> req.setBody((DownloadKieReqBody)v)));
        return builder.build();
    }

    private static HttpRequestDef<ListEnginesRequest, ListEnginesResponse> genForlistEngines() {
        HttpRequestDef.Builder builder = HttpRequestDef.builder((HttpMethod)HttpMethod.GET, ListEnginesRequest.class, ListEnginesResponse.class).withName("ListEngines").withUri("/v2/{project_id}/enginemgr/engines").withContentType("application/json");
        builder.withRequestField("offset", LocationType.Query, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(Integer.class), f -> f.withMarshaller(ListEnginesRequest::getOffset, (req, v) -> req.setOffset((Integer)v)));
        builder.withRequestField("limit", LocationType.Query, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(String.class), f -> f.withMarshaller(ListEnginesRequest::getLimit, (req, v) -> req.setLimit((String)v)));
        return builder.build();
    }

    private static HttpRequestDef<ListFlavorsRequest, ListFlavorsResponse> genForlistFlavors() {
        HttpRequestDef.Builder builder = HttpRequestDef.builder((HttpMethod)HttpMethod.GET, ListFlavorsRequest.class, ListFlavorsResponse.class).withName("ListFlavors").withUri("/v2/{project_id}/enginemgr/flavors").withContentType("application/json");
        builder.withRequestField("spec_type", LocationType.Query, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(String.class), f -> f.withMarshaller(ListFlavorsRequest::getSpecType, (req, v) -> req.setSpecType((String)v)));
        return builder.build();
    }

    private static HttpRequestDef<ShowEngineRequest, ShowEngineResponse> genForshowEngine() {
        HttpRequestDef.Builder builder = HttpRequestDef.builder((HttpMethod)HttpMethod.GET, ShowEngineRequest.class, ShowEngineResponse.class).withName("ShowEngine").withUri("/v2/{project_id}/enginemgr/engines/{engine_id}").withContentType("application/json");
        builder.withRequestField("engine_id", LocationType.Path, FieldExistence.NON_NULL_NON_EMPTY, (Class)TypeCasts.uncheckedConversion(String.class), f -> f.withMarshaller(ShowEngineRequest::getEngineId, (req, v) -> req.setEngineId((String)v)));
        builder.withRequestField("X-Enterprise-Project-ID", LocationType.Header, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(String.class), f -> f.withMarshaller(ShowEngineRequest::getXEnterpriseProjectID, (req, v) -> req.setXEnterpriseProjectID((String)v)));
        return builder.build();
    }

    private static HttpRequestDef<ShowEngineJobRequest, ShowEngineJobResponse> genForshowEngineJob() {
        HttpRequestDef.Builder builder = HttpRequestDef.builder((HttpMethod)HttpMethod.GET, ShowEngineJobRequest.class, ShowEngineJobResponse.class).withName("ShowEngineJob").withUri("/v2/{project_id}/enginemgr/engines/{engine_id}/jobs/{job_id}").withContentType("application/json");
        builder.withRequestField("engine_id", LocationType.Path, FieldExistence.NON_NULL_NON_EMPTY, (Class)TypeCasts.uncheckedConversion(String.class), f -> f.withMarshaller(ShowEngineJobRequest::getEngineId, (req, v) -> req.setEngineId((String)v)));
        builder.withRequestField("job_id", LocationType.Path, FieldExistence.NON_NULL_NON_EMPTY, (Class)TypeCasts.uncheckedConversion(String.class), f -> f.withMarshaller(ShowEngineJobRequest::getJobId, (req, v) -> req.setJobId((String)v)));
        builder.withRequestField("X-Enterprise-Project-ID", LocationType.Header, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(String.class), f -> f.withMarshaller(ShowEngineJobRequest::getXEnterpriseProjectID, (req, v) -> req.setXEnterpriseProjectID((String)v)));
        return builder.build();
    }

    private static HttpRequestDef<UploadKieRequest, UploadKieResponse> genForuploadKie() {
        HttpRequestDef.Builder builder = HttpRequestDef.builder((HttpMethod)HttpMethod.POST, UploadKieRequest.class, UploadKieResponse.class).withName("UploadKie").withUri("/v1/{project_id}/kie/file").withContentType("multipart/form-data");
        builder.withRequestField("override", LocationType.Query, FieldExistence.NON_NULL_NON_EMPTY, (Class)TypeCasts.uncheckedConversion(UploadKieRequest.OverrideEnum.class), f -> f.withMarshaller(UploadKieRequest::getOverride, (req, v) -> req.setOverride((UploadKieRequest.OverrideEnum)v)));
        builder.withRequestField("label", LocationType.Query, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(String.class), f -> f.withMarshaller(UploadKieRequest::getLabel, (req, v) -> req.setLabel((String)v)));
        builder.withRequestField("X-Enterprise-Project-ID", LocationType.Header, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(String.class), f -> f.withMarshaller(UploadKieRequest::getXEnterpriseProjectID, (req, v) -> req.setXEnterpriseProjectID((String)v)));
        builder.withRequestField("x-engine-id", LocationType.Header, FieldExistence.NON_NULL_NON_EMPTY, (Class)TypeCasts.uncheckedConversion(String.class), f -> f.withMarshaller(UploadKieRequest::getXEngineId, (req, v) -> req.setXEngineId((String)v)));
        builder.withRequestField("body", LocationType.Body, FieldExistence.NON_NULL_NON_EMPTY, (Class)TypeCasts.uncheckedConversion(UploadKieRequestBody.class), f -> f.withMarshaller(UploadKieRequest::getBody, (req, v) -> req.setBody((UploadKieRequestBody)v)));
        return builder.build();
    }
}

