/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.io;

import com.obs.services.exception.ObsException;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.io.UnrecoverableIOException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;

public class MayRepeatableInputStream
extends FilterInputStream {
    private FileChannel fileChannel;
    private long markPos;
    private InputStream originInputStream;

    public MayRepeatableInputStream(InputStream in, int bufferSize) {
        super(in);
        this.init(bufferSize);
        this.originInputStream = in;
    }

    private void init(int bufferSize) {
        if (this.in instanceof FileInputStream) {
            this.fileChannel = ((FileInputStream)this.in).getChannel();
            try {
                this.markPos = this.fileChannel.position();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid FileInputStream", e);
            }
        }
        if (bufferSize > 0) {
            this.in = new SdkBufferedInputStream(this.in, bufferSize);
        }
    }

    @Override
    public final boolean markSupported() {
        return this.fileChannel != null || this.originInputStream instanceof ByteArrayInputStream;
    }

    protected final void throwExceptionWhileInterrupted() {
        if (Thread.interrupted()) {
            throw new ObsException("Abort io due to thread interrupted");
        }
    }

    @Override
    public void mark(int a) {
        this.throwExceptionWhileInterrupted();
        try {
            if (this.fileChannel != null) {
                this.markPos = this.fileChannel.position();
            } else if (this.originInputStream instanceof ByteArrayInputStream) {
                ((ByteArrayInputStream)this.originInputStream).mark(a);
            }
        }
        catch (IOException e) {
            throw new ServiceException("Failed to mark the file position", e);
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.fileChannel != null) {
            this.fileChannel.position(this.markPos);
            if (this.in instanceof SdkBufferedInputStream) {
                ((SdkBufferedInputStream)this.in).tearDown();
            }
        } else if (this.originInputStream instanceof ByteArrayInputStream) {
            if (this.in instanceof SdkBufferedInputStream) {
                ((SdkBufferedInputStream)this.in).tearDown();
            }
            ((ByteArrayInputStream)this.originInputStream).reset();
        } else {
            throw new UnrecoverableIOException("UnRepeatable");
        }
    }

    @Override
    public long skip(long n) throws IOException {
        this.throwExceptionWhileInterrupted();
        return super.skip(n);
    }

    @Override
    public int available() throws IOException {
        this.throwExceptionWhileInterrupted();
        return super.available();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.throwExceptionWhileInterrupted();
    }

    @Override
    public int read() throws IOException {
        this.throwExceptionWhileInterrupted();
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.throwExceptionWhileInterrupted();
        return super.read(b, off, len);
    }

    private static class SdkBufferedInputStream
    extends BufferedInputStream {
        public SdkBufferedInputStream(InputStream in, int size) {
            super(in, size);
        }

        public void tearDown() {
            this.count = 0;
            this.markpos = -1;
            this.marklimit = 0;
            this.pos = 0;
        }
    }
}

