/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services;

import com.obs.services.AbstractBucketClient;
import com.obs.services.AbstractClient;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.BaseBucketRequest;
import com.obs.services.model.BucketDirectColdAccess;
import com.obs.services.model.BucketEncryption;
import com.obs.services.model.BucketNotificationConfiguration;
import com.obs.services.model.BucketPolicyResponse;
import com.obs.services.model.BucketTagInfo;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.LifecycleConfiguration;
import com.obs.services.model.ReplicationConfiguration;
import com.obs.services.model.SetBucketDirectColdAccessRequest;
import com.obs.services.model.SetBucketEncryptionRequest;
import com.obs.services.model.SetBucketLifecycleRequest;
import com.obs.services.model.SetBucketNotificationRequest;
import com.obs.services.model.SetBucketPolicyRequest;
import com.obs.services.model.SetBucketReplicationRequest;
import com.obs.services.model.SetBucketTaggingRequest;
import com.obs.services.model.SetBucketWebsiteRequest;
import com.obs.services.model.WebsiteConfiguration;
import com.obs.services.model.fs.GetBucketFSStatusRequest;
import com.obs.services.model.fs.GetBucketFSStatusResult;
import com.obs.services.model.fs.SetBucketFSStatusRequest;

public abstract class AbstractBucketAdvanceClient
extends AbstractBucketClient {
    @Override
    public LifecycleConfiguration getBucketLifecycle(String bucketName) throws ObsException {
        return this.getBucketLifecycle(new BaseBucketRequest(bucketName));
    }

    @Override
    public LifecycleConfiguration getBucketLifecycle(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketLifecycleConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<LifecycleConfiguration>(){

            @Override
            public LifecycleConfiguration action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.getBucketLifecycleConfigurationImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketLifecycle(String bucketName, LifecycleConfiguration lifecycleConfig) throws ObsException {
        return this.setBucketLifecycle(new SetBucketLifecycleRequest(bucketName, lifecycleConfig));
    }

    @Override
    public HeaderResponse setBucketLifecycle(final SetBucketLifecycleRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketLifecycleRequest is null");
        ServiceUtils.asserParameterNotNull(request.getLifecycleConfig(), "LifecycleConfiguration is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("setBucketLifecycleConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.setBucketLifecycleConfigurationImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketLifecycle(String bucketName) throws ObsException {
        return this.deleteBucketLifecycle(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketLifecycle(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucketLifecycleConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.deleteBucketLifecycleConfigurationImpl(request);
            }
        });
    }

    @Override
    public String getBucketPolicy(String bucketName) throws ObsException {
        return this.getBucketPolicyV2(new BaseBucketRequest(bucketName)).getPolicy();
    }

    @Override
    public String getBucketPolicy(BaseBucketRequest request) throws ObsException {
        return this.getBucketPolicyV2(request).getPolicy();
    }

    @Override
    public BucketPolicyResponse getBucketPolicyV2(String bucketName) throws ObsException {
        return this.getBucketPolicyV2(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketPolicyResponse getBucketPolicyV2(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketPolicy", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketPolicyResponse>(){

            @Override
            public BucketPolicyResponse action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.getBucketPolicyImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketPolicy(String bucketName, String policy) throws ObsException {
        return this.setBucketPolicy(new SetBucketPolicyRequest(bucketName, policy));
    }

    @Override
    public HeaderResponse setBucketPolicy(final SetBucketPolicyRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketPolicyRequest is null");
        ServiceUtils.asserParameterNotNull(request.getPolicy(), "policy is null");
        return this.doActionWithResult("setBucketPolicy", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.setBucketPolicyImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketPolicy(String bucketName) throws ObsException {
        return this.deleteBucketPolicy(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketPolicy(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucketPolicy", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.deleteBucketPolicyImpl(request);
            }
        });
    }

    @Override
    public WebsiteConfiguration getBucketWebsite(String bucketName) throws ObsException {
        return this.getBucketWebsite(new BaseBucketRequest(bucketName));
    }

    @Override
    public WebsiteConfiguration getBucketWebsite(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketWebsiteConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<WebsiteConfiguration>(){

            @Override
            public WebsiteConfiguration action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.getBucketWebsiteConfigurationImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketWebsite(String bucketName, WebsiteConfiguration websiteConfig) throws ObsException {
        return this.setBucketWebsite(new SetBucketWebsiteRequest(bucketName, websiteConfig));
    }

    @Override
    public HeaderResponse setBucketWebsite(final SetBucketWebsiteRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketWebsiteRequest is null");
        ServiceUtils.asserParameterNotNull(request.getWebsiteConfig(), "WebsiteConfiguration is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("setBucketWebsiteConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.setBucketWebsiteConfigurationImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketWebsite(String bucketName) throws ObsException {
        return this.deleteBucketWebsite(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketWebsite(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucketWebsiteConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.deleteBucketWebsiteConfigurationImpl(request);
            }
        });
    }

    @Override
    public BucketTagInfo getBucketTagging(String bucketName) throws ObsException {
        return this.getBucketTagging(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketTagInfo getBucketTagging(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketTagging", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketTagInfo>(){

            @Override
            public BucketTagInfo action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.getBucketTaggingImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketTagging(String bucketName, BucketTagInfo bucketTagInfo) throws ObsException {
        return this.setBucketTagging(new SetBucketTaggingRequest(bucketName, bucketTagInfo));
    }

    @Override
    public HeaderResponse setBucketTagging(final SetBucketTaggingRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketTaggingRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("setBucketTagging", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.setBucketTaggingImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketTagging(String bucketName) throws ObsException {
        return this.deleteBucketTagging(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketTagging(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucketTagging", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.deleteBucketTaggingImpl(request);
            }
        });
    }

    @Override
    public BucketEncryption getBucketEncryption(String bucketName) throws ObsException {
        return this.getBucketEncryption(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketEncryption getBucketEncryption(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("getBucketEncryption", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketEncryption>(){

            @Override
            public BucketEncryption action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.getBucketEncryptionImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketEncryption(String bucketName, BucketEncryption bucketEncryption) throws ObsException {
        return this.setBucketEncryption(new SetBucketEncryptionRequest(bucketName, bucketEncryption));
    }

    @Override
    public HeaderResponse setBucketEncryption(final SetBucketEncryptionRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketEncryptionRequest is null");
        ServiceUtils.asserParameterNotNull(request.getBucketEncryption(), "SetBucketEncryptionRequest.bucketEncryption is null");
        return this.doActionWithResult("setBucketEncryption", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.setBucketEncryptionImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketEncryption(String bucketName) throws ObsException {
        return this.deleteBucketEncryption(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketEncryption(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("deleteBucketEncryption", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.deleteBucketEncryptionImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketReplication(String bucketName, ReplicationConfiguration replicationConfiguration) throws ObsException {
        return this.setBucketReplication(new SetBucketReplicationRequest(bucketName, replicationConfiguration));
    }

    @Override
    public HeaderResponse setBucketReplication(final SetBucketReplicationRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketReplicationRequest is null");
        ServiceUtils.asserParameterNotNull(request.getReplicationConfiguration(), "ReplicationConfiguration is null");
        ServiceUtils.asserParameterNotNull(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("setBucketReplication", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.setBucketReplicationConfigurationImpl(request);
            }
        });
    }

    @Override
    public ReplicationConfiguration getBucketReplication(String bucketName) throws ObsException {
        return this.getBucketReplication(new BaseBucketRequest(bucketName));
    }

    @Override
    public ReplicationConfiguration getBucketReplication(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketReplicationConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<ReplicationConfiguration>(){

            @Override
            public ReplicationConfiguration action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.getBucketReplicationConfigurationImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketReplication(String bucketName) throws ObsException {
        return this.deleteBucketReplication(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketReplication(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucketReplicationConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.deleteBucketReplicationConfigurationImpl(request);
            }
        });
    }

    @Override
    public BucketNotificationConfiguration getBucketNotification(String bucketName) throws ObsException {
        return this.getBucketNotification(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketNotificationConfiguration getBucketNotification(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("getBucketNotification", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketNotificationConfiguration>(){

            @Override
            public BucketNotificationConfiguration action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.getBucketNotificationConfigurationImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketNotification(String bucketName, BucketNotificationConfiguration bucketNotificationConfiguration) throws ObsException {
        return this.setBucketNotification(new SetBucketNotificationRequest(bucketName, bucketNotificationConfiguration));
    }

    @Override
    public HeaderResponse setBucketNotification(final SetBucketNotificationRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketNotificationRequest is null");
        return this.doActionWithResult("setBucketNotification", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                if (null == request.getBucketNotificationConfiguration()) {
                    request.setBucketNotificationConfiguration(new BucketNotificationConfiguration());
                }
                return AbstractBucketAdvanceClient.this.setBucketNotificationImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketFSStatus(final SetBucketFSStatusRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketFileInterfaceRequest is null");
        return this.doActionWithResult("setBucketFSStatus", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.setBucketFSStatusImpl(request);
            }
        });
    }

    @Override
    public GetBucketFSStatusResult getBucketFSStatus(final GetBucketFSStatusRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "GetBucketFSStatusRequest is null");
        return this.doActionWithResult("getBucketFSStatus", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<GetBucketFSStatusResult>(){

            @Override
            public GetBucketFSStatusResult action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.getBucketMetadataImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketDirectColdAccess(String bucketName, BucketDirectColdAccess access) throws ObsException {
        return this.setBucketDirectColdAccess(new SetBucketDirectColdAccessRequest(bucketName, access));
    }

    @Override
    public HeaderResponse setBucketDirectColdAccess(final SetBucketDirectColdAccessRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketDirectColdAccessRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        ServiceUtils.asserParameterNotNull(request.getAccess(), "bucketDirectColdAccess is null");
        return this.doActionWithResult("setBucketDirectColdAccess", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.setBucketDirectColdAccessImpl(request);
            }
        });
    }

    @Override
    public BucketDirectColdAccess getBucketDirectColdAccess(String bucketName) throws ObsException {
        return this.getBucketDirectColdAccess(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketDirectColdAccess getBucketDirectColdAccess(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketDirectColdAccess", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketDirectColdAccess>(){

            @Override
            public BucketDirectColdAccess action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.getBucketDirectColdAccessImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketDirectColdAccess(String bucketName) throws ObsException {
        return this.deleteBucketDirectColdAccess(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketDirectColdAccess(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucketDirectColdAccess", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketAdvanceClient.this.deleteBucketDirectColdAccessImpl(request);
            }
        });
    }
}

