/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.schxslt.xslt2;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.file.SimpleFileIO;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.schematron.SchematronDebug;
import com.helger.schematron.SchematronInterruptedException;
import com.helger.schematron.api.xslt.ISchematronXSLTBasedProvider;
import com.helger.schematron.saxon.SchematronTransformerFactory;
import com.helger.schematron.schxslt.xslt2.EStepSchXslt_XSLT2;
import com.helger.schematron.schxslt.xslt2.TransformerCustomizerSchXslt_XSLT2;
import com.helger.xml.XMLFactory;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import com.helger.xml.transform.TransformSourceFactory;
import com.helger.xml.transform.XMLTransformerFactory;
import java.io.File;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@NotThreadSafe
public class SchematronProviderXSLTFromSchXslt_XSLT2
implements ISchematronXSLTBasedProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchematronProviderXSLTFromSchXslt_XSLT2.class);
    public static final String SCHEMATRON_DIRECTORY_XSLT2 = "/xslt/2.0/";
    public static final String XSLT2_STEP1 = "/xslt/2.0/include.xsl";
    public static final String XSLT2_STEP2 = "/xslt/2.0/expand.xsl";
    public static final String XSLT2_STEP3 = "/xslt/2.0/compile-for-svrl.xsl";
    private static Templates s_aStep1;
    private static Templates s_aStep2;
    private static Templates s_aStep3;
    private final IReadableResource m_aSchematronResource;
    private Document m_aSchematronXSLTDoc;
    private Templates m_aSchematronXSLTTemplates;

    public static void cacheXSLTTemplates() {
        TransformerFactory transformerFactory = SchematronTransformerFactory.getDefaultSaxonFirst();
        ClassLoader classLoader = SchematronProviderXSLTFromSchXslt_XSLT2.class.getClassLoader();
        if (s_aStep1 == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating SchXslt step 1 template");
            }
            if ((s_aStep1 = XMLTransformerFactory.newTemplates((TransformerFactory)transformerFactory, (IReadableResource)new ClassPathResource(XSLT2_STEP1, classLoader))) == null) {
                throw new IllegalStateException("Failed to compile '/xslt/2.0/include.xsl'");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Finished creating XSLT step 1 template");
            }
            if (Thread.interrupted()) {
                throw new SchematronInterruptedException("after cached XSLT step 1");
            }
        }
        if (s_aStep2 == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating SchXslt step 2 template");
            }
            if ((s_aStep2 = XMLTransformerFactory.newTemplates((TransformerFactory)transformerFactory, (IReadableResource)new ClassPathResource(XSLT2_STEP2, classLoader))) == null) {
                throw new IllegalStateException("Failed to compile '/xslt/2.0/expand.xsl'");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Finished creating XSLT step 2 template");
            }
            if (Thread.interrupted()) {
                throw new SchematronInterruptedException("after cached XSLT step 2");
            }
        }
        if (s_aStep3 == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating SchXslt step 3 template");
            }
            if ((s_aStep3 = XMLTransformerFactory.newTemplates((TransformerFactory)transformerFactory, (IReadableResource)new ClassPathResource(XSLT2_STEP3, classLoader))) == null) {
                throw new IllegalStateException("Failed to compile '/xslt/2.0/compile-for-svrl.xsl'");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Finished creating XSLT step 3 template");
            }
            if (Thread.interrupted()) {
                throw new SchematronInterruptedException("after cached XSLT step 3");
            }
        }
    }

    @Nonnull
    public static Document createSchematronXSLT(@Nonnull IReadableResource iReadableResource, @Nonnull TransformerCustomizerSchXslt_XSLT2 transformerCustomizerSchXslt_XSLT2) throws TransformerException {
        Object object;
        Object object2;
        if (Thread.interrupted()) {
            throw new SchematronInterruptedException("before XSLT starts");
        }
        SchematronProviderXSLTFromSchXslt_XSLT2.cacheXSLTTemplates();
        Document document = XMLFactory.newDocument();
        DOMResult dOMResult = new DOMResult(document);
        Transformer transformer = s_aStep1.newTransformer();
        transformerCustomizerSchXslt_XSLT2.customize(EStepSchXslt_XSLT2.SCH2XSLT_1, transformer);
        StreamSource streamSource = TransformSourceFactory.create((IReadableResource)iReadableResource);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Now applying XSLT step 1 on " + iReadableResource);
        }
        transformer.transform(streamSource, dOMResult);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished applying SchXslt step 1 on " + iReadableResource);
        }
        if (Thread.interrupted()) {
            throw new SchematronInterruptedException("after XSLT step 1");
        }
        Document document2 = XMLFactory.newDocument();
        DOMResult dOMResult2 = new DOMResult(document2);
        Transformer transformer2 = s_aStep2.newTransformer();
        transformerCustomizerSchXslt_XSLT2.customize(EStepSchXslt_XSLT2.SCH2XSLT_2, transformer2);
        DOMSource dOMSource = TransformSourceFactory.create((Node)document);
        if (dOMSource.getSystemId() == null) {
            dOMSource.setSystemId(streamSource.getSystemId());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Now applying XSLT step 2 on " + iReadableResource);
        }
        transformer2.transform(dOMSource, dOMResult2);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished applying SchXslt step 2 on " + iReadableResource);
        }
        if (SchematronDebug.isSaveIntermediateXSLTFiles()) {
            object2 = XMLWriter.getNodeAsString((Node)document2);
            object = new File(SchematronDebug.getIntermediateMinifiedSCHFolder(), FilenameHelper.getWithoutPath((String)iReadableResource.getPath()) + ".min-xslt.sch");
            if (SimpleFileIO.writeFile((File)object, (String)object2, (Charset)XMLWriterSettings.DEFAULT_XML_CHARSET_OBJ).isSuccess()) {
                LOGGER.info("Successfully wrote intermediate XSLT file '" + ((File)object).getAbsolutePath() + "'");
            } else {
                LOGGER.error("Failed to wrote intermediate XSLT file '" + ((File)object).getAbsolutePath() + "'");
            }
        }
        if (Thread.interrupted()) {
            throw new SchematronInterruptedException("after XSLT step 2");
        }
        object2 = XMLFactory.newDocument();
        object = new DOMResult((Node)object2);
        Transformer transformer3 = s_aStep3.newTransformer();
        transformerCustomizerSchXslt_XSLT2.customize(EStepSchXslt_XSLT2.SCH2XSLT_3, transformer3);
        DOMSource dOMSource2 = TransformSourceFactory.create((Node)document2);
        if (dOMSource2.getSystemId() == null) {
            dOMSource2.setSystemId(streamSource.getSystemId());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Now applying XSLT step 3 on " + iReadableResource);
        }
        transformer3.transform(dOMSource2, (Result)object);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished applying SchXslt step 3 on " + iReadableResource);
        }
        if (SchematronDebug.isSaveIntermediateXSLTFiles()) {
            String string = XMLWriter.getNodeAsString((Node)object2);
            File file = new File(SchematronDebug.getIntermediateFinalXSLTFolder(), FilenameHelper.getWithoutPath((String)iReadableResource.getPath()) + ".xslt");
            if (SimpleFileIO.writeFile((File)file, (String)string, (Charset)XMLWriterSettings.DEFAULT_XML_CHARSET_OBJ).isSuccess()) {
                LOGGER.info("Successfully wrote intermediate XSLT file '" + file.getAbsolutePath() + "'");
            } else {
                LOGGER.error("Failed to wrote intermediate XSLT file '" + file.getAbsolutePath() + "'");
            }
        }
        if (Thread.interrupted()) {
            throw new SchematronInterruptedException("after XSLT step 3");
        }
        return object2;
    }

    public SchematronProviderXSLTFromSchXslt_XSLT2(@Nonnull IReadableResource iReadableResource, @Nonnull TransformerCustomizerSchXslt_XSLT2 transformerCustomizerSchXslt_XSLT2) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"SchematronResource");
        ValueEnforcer.notNull((Object)transformerCustomizerSchXslt_XSLT2, (String)"TransformerCustomizer");
        this.m_aSchematronResource = iReadableResource;
        try {
            this.m_aSchematronXSLTDoc = SchematronProviderXSLTFromSchXslt_XSLT2.createSchematronXSLT(iReadableResource, transformerCustomizerSchXslt_XSLT2);
            TransformerFactory transformerFactory = SchematronTransformerFactory.getDefaultSaxonFirst();
            transformerCustomizerSchXslt_XSLT2.customize(transformerFactory);
            this.m_aSchematronXSLTTemplates = XMLTransformerFactory.newTemplates((TransformerFactory)transformerFactory, (Source)TransformSourceFactory.create((Node)this.m_aSchematronXSLTDoc));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Finished creating XSLT Template on " + iReadableResource);
            }
        }
        catch (SchematronInterruptedException schematronInterruptedException) {
            throw schematronInterruptedException;
        }
        catch (Exception exception) {
            LOGGER.error("SchXslt preprocessor error", (Throwable)exception);
        }
        if (Thread.interrupted()) {
            throw new SchematronInterruptedException("after XSLT template was created");
        }
    }

    @Nonnull
    public IReadableResource getSchematronResource() {
        return this.m_aSchematronResource;
    }

    public boolean isValidSchematron() {
        return this.m_aSchematronXSLTTemplates != null;
    }

    @Nullable
    public Document getXSLTDocument() {
        return this.m_aSchematronXSLTDoc;
    }

    @Nullable
    public Transformer getXSLTTransformer() throws TransformerConfigurationException {
        return this.m_aSchematronXSLTTemplates == null ? null : this.m_aSchematronXSLTTemplates.newTransformer();
    }
}

