/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.system.SystemProperties;
import com.helger.schematron.pure.xpath.IXPathConfig;
import com.helger.schematron.pure.xpath.XPathConfig;
import com.helger.xml.xpath.XPathHelper;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPathConfigBuilder {
    public static final XPathFactory XPATH_FACTORY_SAXON_FIRST = XPathHelper.createXPathFactorySaxonFirst();
    public static final IXPathConfig DEFAULT = new XPathConfig(XPATH_FACTORY_SAXON_FIRST, null, null);
    private static final Logger LOGGER = LoggerFactory.getLogger(XPathConfigBuilder.class);
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private XPathFactory m_aXPathFactory;
    private Class<? extends XPathFactory> m_aXPathFactoryClass;
    private String m_sGlobalXPathFactory;
    private XPathVariableResolver m_aXPathVariableResolver;
    private XPathFunctionResolver m_aXPathFunctionResolver;

    @Nullable
    public final XPathFactory getXPathFactory() {
        return this.m_aXPathFactory;
    }

    @Nonnull
    public final XPathConfigBuilder setXPathFactory(@Nonnull XPathFactory xPathFactory) {
        ValueEnforcer.notNull((Object)xPathFactory, (String)"XPathFactoryClass");
        this.m_aXPathFactory = xPathFactory;
        return this;
    }

    @Nullable
    public final Class<? extends XPathFactory> getXPathFactoryClass() {
        return this.m_aXPathFactoryClass;
    }

    @Nonnull
    public final XPathConfigBuilder setXPathFactoryClass(@Nonnull Class<? extends XPathFactory> clazz) {
        ValueEnforcer.notNull(clazz, (String)"XPathFactoryClass");
        this.m_aXPathFactoryClass = clazz;
        return this;
    }

    @Nullable
    public final String getGlobalXPathFactory() {
        return this.m_sGlobalXPathFactory;
    }

    @Nonnull
    public final XPathConfigBuilder setGlobalXPathFactory(@Nullable String string) {
        this.m_sGlobalXPathFactory = string;
        return this;
    }

    @Nullable
    public final XPathVariableResolver getXPathVariableResolver() {
        return this.m_aXPathVariableResolver;
    }

    @Nonnull
    public final XPathConfigBuilder setXPathVariableResolver(@Nullable XPathVariableResolver xPathVariableResolver) {
        this.m_aXPathVariableResolver = xPathVariableResolver;
        return this;
    }

    @Nullable
    public final XPathFunctionResolver getXPathFunctionResolver() {
        return this.m_aXPathFunctionResolver;
    }

    @Nonnull
    public final XPathConfigBuilder setXPathFunctionResolver(@Nullable XPathFunctionResolver xPathFunctionResolver) {
        this.m_aXPathFunctionResolver = xPathFunctionResolver;
        return this;
    }

    @Nonnull
    public IXPathConfig build() throws XPathFactoryConfigurationException {
        XPathFactory xPathFactory = this.m_aXPathFactory;
        if (xPathFactory == null) {
            if (StringHelper.hasText((String)this.m_sGlobalXPathFactory) && SystemProperties.setPropertyValue((String)"javax.xml.xpath.XPathFactory", (String)this.m_sGlobalXPathFactory).isChanged()) {
                LOGGER.info("Setting global system property 'javax.xml.xpath.XPathFactory' to '" + this.m_sGlobalXPathFactory + "'");
            }
            if (this.m_aXPathFactoryClass != null) {
                try {
                    xPathFactory = this.m_aXPathFactoryClass.getConstructor(EMPTY_CLASS_ARRAY).newInstance(ArrayHelper.EMPTY_OBJECT_ARRAY);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new XPathFactoryConfigurationException(invocationTargetException.getCause());
                }
                catch (Exception exception) {
                    throw new XPathFactoryConfigurationException(exception);
                }
            } else {
                xPathFactory = StringHelper.hasText((String)this.m_sGlobalXPathFactory) ? XPathFactory.newInstance() : XPATH_FACTORY_SAXON_FIRST;
            }
        }
        return new XPathConfig(xPathFactory, this.m_aXPathVariableResolver, this.m_aXPathFunctionResolver);
    }
}

