/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.errorhandler;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.error.IError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.AbstractPSErrorHandler;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractCollectingPSErrorHandler
extends AbstractPSErrorHandler {
    private final ErrorList m_aErrorList;

    public AbstractCollectingPSErrorHandler(@Nonnull ErrorList errorList, @Nullable IPSErrorHandler iPSErrorHandler) {
        super(iPSErrorHandler);
        this.m_aErrorList = (ErrorList)ValueEnforcer.notNull((Object)errorList, (String)"ErrorList");
    }

    @Override
    protected void handleInternally(@Nonnull IError iError) {
        this.m_aErrorList.add((Object)iError);
    }

    @Nonnull
    @ReturnsMutableCopy
    public IErrorList getErrorList() {
        return this.m_aErrorList.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public IErrorList getAllFailures() {
        return this.m_aErrorList.getAllFailures();
    }

    @Nonnull
    @ReturnsMutableCopy
    public IErrorList getAllErrors() {
        return this.m_aErrorList.getAllErrors();
    }

    @Nonnull
    public EChange clearResourceErrors() {
        return this.m_aErrorList.removeAll();
    }

    public boolean isEmpty() {
        return this.m_aErrorList.isEmpty();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("ErrorList", (Object)this.m_aErrorList).getToString();
    }
}

