/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.bound.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundAssertReport;
import com.helger.schematron.pure.model.PSRule;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.xml.xpath.XPathExpression;

@Immutable
public class PSXPathBoundRule {
    private final PSRule m_aRule;
    private final String m_sRuleContext;
    private final XPathExpression m_aBoundRuleContext;
    private final ICommonsList<PSXPathBoundAssertReport> m_aBoundAssertReports;

    public PSXPathBoundRule(@Nonnull PSRule pSRule, @Nonnull String string, @Nonnull XPathExpression xPathExpression, @Nonnull ICommonsList<PSXPathBoundAssertReport> iCommonsList) {
        ValueEnforcer.notNull((Object)pSRule, (String)"Rule");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"RuleContext");
        ValueEnforcer.notNull((Object)xPathExpression, (String)"BoundRuleContext");
        ValueEnforcer.notNull(iCommonsList, (String)"BoundAssertReports");
        this.m_aRule = pSRule;
        this.m_sRuleContext = string;
        this.m_aBoundRuleContext = xPathExpression;
        this.m_aBoundAssertReports = iCommonsList;
    }

    @Nonnull
    public final PSRule getRule() {
        return this.m_aRule;
    }

    @Nonnull
    public final String getRuleContext() {
        return this.m_sRuleContext;
    }

    @Nonnull
    public final XPathExpression getBoundRuleContext() {
        return this.m_aBoundRuleContext;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<PSXPathBoundAssertReport> boundAssertReports() {
        return this.m_aBoundAssertReports;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<PSXPathBoundAssertReport> getAllBoundAssertReports() {
        return (ICommonsList)this.m_aBoundAssertReports.getClone();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("rule", (Object)this.m_aRule).append("ruleExpression", (Object)this.m_sRuleContext).append("boundRuleExpression", (Object)this.m_aBoundRuleContext).append("boundAssertReports", this.m_aBoundAssertReports).getToString();
    }
}

