/*
 * Decompiled with CFR 0.152.
 */
package com.helger.maven.schematron;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.Since;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.ExecutorServiceHelper;
import com.helger.commons.concurrent.ThreadHelper;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.StringHelper;
import com.helger.commons.wrapper.Wrapper;
import com.helger.maven.schematron.PluginErrorListener;
import com.helger.schematron.sch.SchematronProviderXSLTFromSCH;
import com.helger.schematron.sch.TransformerCustomizerSCH;
import com.helger.xml.XMLHelper;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.ErrorListener;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.slf4j.impl.StaticLoggerBinder;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD", "UWF_UNWRITTEN_FIELD"})
@Mojo(name="convert", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public final class Schematron2XSLTMojo
extends AbstractMojo {
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(name="schematronDirectory", defaultValue="${basedir}/src/main/schematron", required=true)
    private File m_aSchematronDirectory;
    @Parameter(name="schematronPattern", defaultValue="**/*.sch", required=true)
    private String m_sSchematronPattern;
    @Parameter(name="xsltDirectory", defaultValue="${basedir}/src/main/xslt", required=true)
    private File m_aXsltDirectory;
    @Parameter(name="xsltExtension", defaultValue=".xslt", required=true)
    private String m_sXsltExtension;
    @Parameter(name="overwriteWithoutQuestion", defaultValue="true")
    private boolean m_bOverwriteWithoutQuestion = true;
    @Parameter(name="phaseName")
    private String m_sPhaseName;
    @Parameter(name="languageCode")
    private String m_sLanguageCode;
    @Parameter(name="parameters")
    @Since(value="5.0.2")
    private Map<String, String> m_aCustomParameters;
    @Parameter(name="forceCacheResult", defaultValue="false")
    @Since(value="5.2.1")
    private boolean m_bForceCacheResult = false;
    @Parameter(name="xsltHeader")
    @Since(value="6.2.2")
    private String m_sXSLTHeader;
    @Parameter(name="showProgress", defaultValue="true")
    @Since(value="6.2.8")
    private boolean m_bShowProgress = true;

    public void setSchematronDirectory(@Nonnull File file) {
        this.m_aSchematronDirectory = file;
        if (!this.m_aSchematronDirectory.isAbsolute()) {
            this.m_aSchematronDirectory = new File(this.project.getBasedir(), file.getPath());
        }
        this.getLog().debug((CharSequence)("Searching Schematron files in the directory '" + this.m_aSchematronDirectory + "'"));
    }

    public void setSchematronPattern(@Nonnull String string) {
        this.m_sSchematronPattern = string;
        this.getLog().debug((CharSequence)("Setting Schematron pattern to '" + string + "'"));
    }

    public void setXsltDirectory(@Nonnull File file) {
        this.m_aXsltDirectory = file;
        if (!this.m_aXsltDirectory.isAbsolute()) {
            this.m_aXsltDirectory = new File(this.project.getBasedir(), file.getPath());
        }
        this.getLog().debug((CharSequence)("Writing XSLT files into directory '" + this.m_aXsltDirectory + "'"));
    }

    public void setXsltExtension(@Nonnull String string) {
        this.m_sXsltExtension = string;
        this.getLog().debug((CharSequence)("Setting XSLT file extension to '" + string + "'"));
    }

    public void setOverwriteWithoutQuestion(boolean bl) {
        this.m_bOverwriteWithoutQuestion = bl;
        if (this.m_bOverwriteWithoutQuestion) {
            this.getLog().debug((CharSequence)"Overwriting XSLT files without notice");
        } else {
            this.getLog().debug((CharSequence)"Ignoring existing Schematron files");
        }
    }

    public void setPhaseName(@Nullable String string) {
        this.m_sPhaseName = string;
        if (this.m_sPhaseName == null) {
            this.getLog().debug((CharSequence)"Using default phase");
        } else {
            this.getLog().debug((CharSequence)("Using the phase '" + this.m_sPhaseName + "'"));
        }
    }

    public void setLanguageCode(@Nullable String string) {
        this.m_sLanguageCode = string;
        if (this.m_sLanguageCode == null) {
            this.getLog().debug((CharSequence)"Using default language code");
        } else {
            this.getLog().debug((CharSequence)("Using the language code '" + this.m_sLanguageCode + "'"));
        }
    }

    public void setParameters(@Nullable Map<String, String> map) {
        this.m_aCustomParameters = map;
        if (this.m_aCustomParameters == null || this.m_aCustomParameters.isEmpty()) {
            this.getLog().debug((CharSequence)"Using no custom parameters");
        } else {
            this.getLog().debug((CharSequence)("Using custom parameters " + this.m_aCustomParameters.toString()));
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    ICommonsMap<String, String> getParameters() {
        return new CommonsHashMap(this.m_aCustomParameters);
    }

    public void setForceCacheResult(boolean bl) {
        this.m_bForceCacheResult = bl;
        if (this.m_bForceCacheResult) {
            this.getLog().debug((CharSequence)"Results are forcebly cached");
        } else {
            this.getLog().debug((CharSequence)"Results not not forcebly cached");
        }
    }

    public void setXsltHeader(String string) {
        this.m_sXSLTHeader = string;
        if (StringHelper.hasText((String)this.m_sXSLTHeader)) {
            this.getLog().debug((CharSequence)("Using the XSLT header '" + this.m_sXSLTHeader + "'"));
        } else {
            this.getLog().debug((CharSequence)"No XSLT header is configured");
        }
    }

    public void setShowProgress(boolean bl) {
        this.m_bShowProgress = bl;
        if (bl) {
            this.getLog().debug((CharSequence)"Progress indicator is enabled");
        } else {
            this.getLog().debug((CharSequence)"Progress indicator is disabled");
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        if (this.m_aSchematronDirectory == null) {
            throw new MojoExecutionException("No Schematron directory specified!");
        }
        if (this.m_aSchematronDirectory.exists() && !this.m_aSchematronDirectory.isDirectory()) {
            throw new MojoExecutionException("The specified Schematron directory " + this.m_aSchematronDirectory + " is not a directory!");
        }
        if (StringHelper.hasNoText((String)this.m_sSchematronPattern)) {
            throw new MojoExecutionException("No Schematron pattern specified!");
        }
        if (this.m_aXsltDirectory == null) {
            throw new MojoExecutionException("No XSLT directory specified!");
        }
        if (this.m_aXsltDirectory.exists() && !this.m_aXsltDirectory.isDirectory()) {
            throw new MojoExecutionException("The specified XSLT directory " + this.m_aXsltDirectory + " is not a directory!");
        }
        if (StringHelper.hasNoText((String)this.m_sXsltExtension) || !this.m_sXsltExtension.startsWith(".")) {
            throw new MojoExecutionException("The XSLT extension '" + this.m_sXsltExtension + "' is invalid!");
        }
        if (!this.m_aXsltDirectory.exists() && !this.m_aXsltDirectory.mkdirs()) {
            throw new MojoExecutionException("Failed to create the XSLT directory " + this.m_aXsltDirectory);
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(this.m_aSchematronDirectory);
        directoryScanner.setIncludes(new String[]{this.m_sSchematronPattern});
        directoryScanner.setCaseSensitive(true);
        directoryScanner.scan();
        String[] stringArray = directoryScanner.getIncludedFiles();
        if (stringArray != null) {
            for (String string : stringArray) {
                Object object;
                File file = new File(this.m_aSchematronDirectory, string);
                File file2 = new File(this.m_aXsltDirectory, FilenameHelper.getWithoutExtension((String)string) + this.m_sXsltExtension);
                this.getLog().info((CharSequence)("Converting Schematron file '" + file.getPath() + "' to XSLT file '" + file2.getPath() + "'"));
                FileSystemResource fileSystemResource = new FileSystemResource(file);
                if (file2.exists() && !this.m_bOverwriteWithoutQuestion) {
                    this.getLog().debug((CharSequence)("Skipping XSLT file '" + file2.getPath() + "' because it already exists!"));
                    continue;
                }
                File file3 = file2.getParentFile();
                if (file3 != null && !file3.exists()) {
                    this.getLog().debug((CharSequence)("Creating directory '" + file3.getPath() + "'"));
                    if (!file3.mkdirs()) {
                        object = "Failed to convert '" + file.getPath() + "' because directory '" + file3.getPath() + "' could not be created";
                        this.getLog().error((CharSequence)object);
                        throw new MojoFailureException((String)object);
                    }
                }
                object = new Wrapper();
                Wrapper wrapper = new Wrapper();
                Runnable runnable = () -> this.lambda$execute$1(file, (IReadableResource)fileSystemResource, file2, file3, (Wrapper)object, wrapper);
                if (this.m_bShowProgress) {
                    ExecutorService executorService = Executors.newSingleThreadExecutor();
                    executorService.submit(runnable);
                    long l = System.currentTimeMillis();
                    AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                    Thread thread = new Thread(() -> {
                        long l2 = 0L;
                        while (!Thread.currentThread().isInterrupted()) {
                            long l3;
                            if (!ThreadHelper.sleep((long)500L).isSuccess() || (l3 = (System.currentTimeMillis() - l) / 1000L) < l2 + 5L) continue;
                            this.getLog().info((CharSequence)("Schematron conversion of '" + file.getName() + "' already takes " + l3 + " seconds - please wait..."));
                            l2 = l3;
                            atomicBoolean.set(true);
                        }
                    });
                    thread.setDaemon(true);
                    thread.start();
                    ExecutorServiceHelper.shutdownAndWaitUntilAllTasksAreFinished((ExecutorService)executorService);
                    thread.interrupt();
                    if (atomicBoolean.get()) {
                        long l2 = (System.currentTimeMillis() - l) / 1000L;
                        this.getLog().info((CharSequence)("Schematron conversion of '" + file.getName() + "' was finalized after " + l2 + " seconds"));
                    }
                } else {
                    runnable.run();
                }
                if (object.isSet()) {
                    throw (MojoFailureException)((Object)object.get());
                }
                if (!wrapper.isSet()) continue;
                throw (MojoExecutionException)wrapper.get();
            }
        }
    }

    private /* synthetic */ void lambda$execute$1(File file, IReadableResource iReadableResource, File file2, File file3, Wrapper wrapper, Wrapper wrapper2) {
        try {
            FileOutputStream fileOutputStream;
            XMLWriterSettings xMLWriterSettings;
            this.buildContext.removeMessages(file);
            PluginErrorListener pluginErrorListener = new PluginErrorListener(this.buildContext, file);
            TransformerCustomizerSCH transformerCustomizerSCH = new TransformerCustomizerSCH().setErrorListener((ErrorListener)((Object)pluginErrorListener)).setPhase(this.m_sPhaseName).setLanguageCode(this.m_sLanguageCode).setParameters(this.m_aCustomParameters).setForceCacheResult(this.m_bForceCacheResult);
            this.getLog().debug((CharSequence)("Compiling Schematron instance " + iReadableResource.toString()));
            Document document = SchematronProviderXSLTFromSCH.createSchematronXSLT((IReadableResource)iReadableResource, (TransformerCustomizerSCH)transformerCustomizerSCH);
            if (document != null) {
                if (StringHelper.hasText((String)this.m_sXSLTHeader)) {
                    document.insertBefore(document.createComment(this.m_sXSLTHeader), document.getDocumentElement());
                }
                MapBasedNamespaceContext mapBasedNamespaceContext = new MapBasedNamespaceContext().addMapping("svrl", "http://purl.oclc.org/dsdl/svrl");
                String string3 = "xmlns:";
                XMLHelper.forAllAttributes((Element)document.getDocumentElement(), (string, string2) -> {
                    if (string.startsWith("xmlns:")) {
                        mapBasedNamespaceContext.addMapping(string.substring("xmlns:".length()), string2);
                    }
                });
                xMLWriterSettings = new XMLWriterSettings().setNamespaceContext((NamespaceContext)mapBasedNamespaceContext).setPutNamespaceContextPrefixesInRoot(true);
                fileOutputStream = FileHelper.getOutputStream((File)file2);
                if (fileOutputStream == null) {
                    throw new IllegalStateException("Failed to open output stream for file " + file2.getAbsolutePath());
                }
            } else {
                String string4 = "Failed to convert '" + file.getPath() + "': the Schematron resource is invalid";
                this.getLog().error((CharSequence)string4);
                throw new MojoFailureException(string4);
            }
            XMLWriter.writeToStream((Node)document, (OutputStream)fileOutputStream, (IXMLWriterSettings)xMLWriterSettings);
            this.getLog().debug((CharSequence)("Finished creating XSLT file '" + file2.getPath() + "'"));
            this.buildContext.refresh(file3);
        }
        catch (MojoFailureException mojoFailureException) {
            wrapper.set((Object)mojoFailureException);
        }
        catch (Exception exception) {
            String string5 = "Failed to convert '" + file.getPath() + "' to XSLT file '" + file2.getPath() + "'";
            this.getLog().error((CharSequence)string5, (Throwable)exception);
            wrapper2.set((Object)new MojoExecutionException(string5, exception));
        }
    }
}

