/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mock;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsTreeMap;
import com.helger.commons.collection.impl.CommonsTreeSet;
import com.helger.commons.collection.impl.ICommonsSortedMap;
import com.helger.commons.collection.impl.ICommonsSortedSet;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FileSystemIterator;
import com.helger.commons.io.stream.NonBlockingBufferedReader;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.lang.ReflectionSecurityManager;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.commons.string.StringHelper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SPITestHelper {
    public static final String TEST_SERVICES = "src/test/resources/META-INF/services";
    public static final String MAIN_SERVICES = "src/main/resources/META-INF/services";
    private static final Logger LOGGER = LoggerFactory.getLogger(SPITestHelper.class);

    private SPITestHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSortedMap<String, ICommonsSortedSet<String>> testIfAllSPIImplementationsAreValid(@Nonnull String string2, @Nonnull EMode eMode) throws IOException {
        ValueEnforcer.notNull(string2, "BaseDir");
        ValueEnforcer.notNull(eMode, "Mode");
        boolean bl = eMode.isResolve();
        ClassLoader classLoader = ReflectionSecurityManager.INSTANCE.getCallerClass(1).getClassLoader();
        CommonsTreeMap<String, ICommonsSortedSet<String>> commonsTreeMap = new CommonsTreeMap<String, ICommonsSortedSet<String>>();
        File file = new File(string2);
        if (file.exists() && file.isDirectory()) {
            for (File file2 : new FileSystemIterator(string2)) {
                Object object;
                String string3;
                block20: {
                    if (!file2.isFile()) continue;
                    if (bl && LOGGER.isInfoEnabled()) {
                        LOGGER.info("Checking SPI file " + file2.getAbsolutePath());
                    }
                    string3 = file2.getName();
                    if (bl) {
                        try {
                            object = classLoader.loadClass(string3);
                            if (string3.startsWith("com.helger.") && !ServiceLoaderHelper.CACHE_INTERFACE.hasAnnotation((Class<?>)object) && LOGGER.isWarnEnabled()) {
                                LOGGER.warn(object + " should have the @IsSPIInterface annotation");
                            }
                        }
                        catch (Exception exception) {
                            String string4 = "No interface representing " + string3 + " exists: " + ClassHelper.getClassLocalName(exception) + " - " + exception.getMessage();
                            if (LOGGER.isWarnEnabled()) {
                                LOGGER.warn(string4);
                            }
                            if (!eMode.isStrict()) break block20;
                            throw new IllegalStateException(string4);
                        }
                    }
                }
                object = new NonBlockingBufferedReader(StreamHelper.createReader(FileHelper.getInputStream(file2), StandardCharsets.UTF_8));
                try {
                    String string5;
                    int n = 0;
                    while ((string5 = ((NonBlockingBufferedReader)object).readLine()) != null) {
                        String string6 = StringHelper.trim(string5);
                        if (!StringHelper.hasText(string6)) continue;
                        if (bl) {
                            try {
                                Class<?> clazz = classLoader.loadClass(string6);
                                if (!ServiceLoaderHelper.CACHE_IMPLEMENTATION.hasAnnotation(clazz) && LOGGER.isWarnEnabled()) {
                                    LOGGER.warn(clazz + " should have the @IsSPIImplementation annotation");
                                }
                                ++n;
                                commonsTreeMap.computeIfAbsent(string3, string -> new CommonsTreeSet()).add(string6);
                                continue;
                            }
                            catch (Exception exception) {
                                if (LOGGER.isWarnEnabled()) {
                                    LOGGER.warn("  Error checking content: " + exception.getMessage());
                                }
                                if (!eMode.isStrict()) continue;
                                throw new IllegalStateException("Error checking SPI file " + file2.getAbsolutePath(), exception);
                            }
                        }
                        ++n;
                        commonsTreeMap.computeIfAbsent(string3, string -> new CommonsTreeSet()).add(string6);
                    }
                    if (!bl) continue;
                    if (n == 0) {
                        LOGGER.warn("  Contains no single valid implementation!");
                        continue;
                    }
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("  All implementations (" + n + ") are valid!");
                }
                finally {
                    ((NonBlockingBufferedReader)object).close();
                }
            }
        }
        return commonsTreeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSortedMap<String, ICommonsSortedSet<String>> testIfAllMainSPIImplementationsAreValid(boolean bl) throws IOException {
        return SPITestHelper.testIfAllSPIImplementationsAreValid(MAIN_SERVICES, bl ? EMode.IGNORE_ERRORS : EMode.STRICT);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSortedMap<String, ICommonsSortedSet<String>> testIfAllTestSPIImplementationsAreValid(boolean bl) throws IOException {
        return SPITestHelper.testIfAllSPIImplementationsAreValid(TEST_SERVICES, bl ? EMode.IGNORE_ERRORS : EMode.STRICT);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSortedMap<String, ICommonsSortedSet<String>> testIfAllSPIImplementationsAreValid(boolean bl) throws IOException {
        ICommonsSortedMap<String, ICommonsSortedSet<String>> iCommonsSortedMap = SPITestHelper.testIfAllMainSPIImplementationsAreValid(bl);
        iCommonsSortedMap.putAll(SPITestHelper.testIfAllTestSPIImplementationsAreValid(bl));
        return iCommonsSortedMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSortedMap<String, ICommonsSortedSet<String>> testIfAllSPIImplementationsAreValid() throws IOException {
        return SPITestHelper.testIfAllSPIImplementationsAreValid(false);
    }

    public static enum EMode {
        STRICT,
        IGNORE_ERRORS,
        NO_RESOLVE;


        public boolean isStrict() {
            return this == STRICT;
        }

        public boolean isResolve() {
            return this != NO_RESOLVE;
        }
    }
}

