/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.lang;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsIterable;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.commons.collection.map.LRUMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ClassHierarchyCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassHierarchyCache.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static final ICommonsMap<String, ClassList> CLASS_HIERARCHY = new LRUMap<String, ClassList>(1000);
    private static final ClassHierarchyCache INSTANCE = new ClassHierarchyCache();

    private ClassHierarchyCache() {
    }

    @Nonnull
    public static EChange clearCache() {
        EChange eChange = RW_LOCK.writeLockedGet(CLASS_HIERARCHY::removeAll);
        if (eChange.isUnchanged()) {
            return EChange.UNCHANGED;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cache was cleared: " + ClassHierarchyCache.class.getName());
        }
        return EChange.CHANGED;
    }

    @Nonnull
    private static ClassList _getClassList(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        String string = clazz.getName();
        ClassList classList = RW_LOCK.readLockedGet(() -> (ClassList)CLASS_HIERARCHY.get(string));
        if (classList == null) {
            classList = RW_LOCK.writeLockedGet(() -> CLASS_HIERARCHY.computeIfAbsent(string, string -> new ClassList(clazz)));
        }
        return classList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<Class<?>> getClassHierarchy(@Nonnull Class<?> clazz) {
        return ClassHierarchyCache._getClassList(clazz).getAsSet();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<Class<?>> getClassHierarchyList(@Nonnull Class<?> clazz) {
        return ClassHierarchyCache._getClassList(clazz).getAsList();
    }

    @Nonnull
    public static ICommonsIterable<WeakReference<Class<?>>> getClassHierarchyIterator(@Nonnull Class<?> clazz) {
        return ClassHierarchyCache._getClassList(clazz);
    }

    @Immutable
    private static final class ClassList
    implements ICommonsIterable<WeakReference<Class<?>>> {
        private final ICommonsList<WeakReference<Class<?>>> m_aList = new CommonsArrayList();

        public ClassList(@Nonnull Class<?> clazz) {
            ValueEnforcer.notNull(clazz, "Class");
            CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            commonsArrayList.add(clazz);
            while (!commonsArrayList.isEmpty()) {
                Class clazz2 = (Class)commonsArrayList.removeFirst();
                commonsLinkedHashSet.add(clazz2);
                for (Class<?> clazz3 : clazz2.getInterfaces()) {
                    commonsArrayList.add(0, clazz3);
                }
                if (clazz2.getSuperclass() == null) continue;
                commonsArrayList.add(0, clazz2.getSuperclass());
            }
            for (Class<?>[] classArray : commonsLinkedHashSet) {
                this.m_aList.add(new WeakReference<Class<?>[]>(classArray));
            }
        }

        @Nonnull
        @ReturnsMutableCopy
        public ICommonsOrderedSet<Class<?>> getAsSet() {
            CommonsLinkedHashSet<int> commonsLinkedHashSet = new CommonsLinkedHashSet<int>(this.m_aList.size());
            for (WeakReference weakReference : this.m_aList) {
                Class clazz = (Class)weakReference.get();
                if (clazz == null) continue;
                commonsLinkedHashSet.add(clazz);
            }
            return commonsLinkedHashSet;
        }

        @Nonnull
        @ReturnsMutableCopy
        public ICommonsList<Class<?>> getAsList() {
            CommonsArrayList<int> commonsArrayList = new CommonsArrayList<int>(this.m_aList.size());
            for (WeakReference weakReference : this.m_aList) {
                Class clazz = (Class)weakReference.get();
                if (clazz == null) continue;
                commonsArrayList.add(clazz);
            }
            return commonsArrayList;
        }

        @Override
        @Nonnull
        public IIterableIterator<WeakReference<Class<?>>> iterator() {
            return this.m_aList.iterator2();
        }

        public String toString() {
            return new ToStringGenerator(this).append("list", this.m_aList).getToString();
        }
    }
}

