/*
 * Decompiled with CFR 0.152.
 */
package com.headius.backport9.stack.impl;

import com.headius.backport9.stack.StackWalker;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Stream;

public class StackWalker8
implements StackWalker {
    @Override
    public <T> T walk(Function<? super Stream<StackWalker.StackFrame>, ? extends T> function) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        return StackWalker8.walkElements(stackTrace, Math.min(1, stackTrace.length), stackTrace.length, function);
    }

    public static <T> T walkElements(StackTraceElement[] trace, int startInclusive, int endExclusive, Function<? super Stream<StackWalker.StackFrame>, ? extends T> function) {
        Stream<StackWalker.StackFrame> stream = Arrays.stream(trace, startInclusive, endExclusive).map(element -> new StackFrame8((StackTraceElement)element));
        return function.apply(stream);
    }

    public static class StackFrame8
    implements StackWalker.StackFrame {
        final StackTraceElement element;

        public StackFrame8(StackTraceElement element) {
            this.element = element;
        }

        @Override
        public String getClassName() {
            return this.element.getClassName();
        }

        @Override
        public String getMethodName() {
            return this.element.getMethodName();
        }

        @Override
        public Class<?> getDeclaringClass() {
            return null;
        }

        @Override
        public int getByteCodeIndex() {
            return -1;
        }

        @Override
        public String getFileName() {
            return this.element.getFileName();
        }

        @Override
        public int getLineNumber() {
            return this.element.getLineNumber();
        }

        @Override
        public boolean isNativeMethod() {
            return this.element.isNativeMethod();
        }

        @Override
        public StackTraceElement toStackTraceElement() {
            return this.element;
        }
    }
}

