/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.cluster.AddressChecker;
import com.hazelcast.internal.util.AddressUtil;
import com.hazelcast.logging.ILogger;
import java.util.Set;

public final class AddressCheckerImpl
implements AddressChecker {
    private final Set<String> trustedInterfaces;
    private final ILogger logger;

    public AddressCheckerImpl(Set<String> trustedInterfaces, ILogger logger) {
        this.trustedInterfaces = trustedInterfaces;
        this.logger = logger;
    }

    @Override
    public boolean isTrusted(Address address) {
        if (address == null) {
            return false;
        }
        if (this.trustedInterfaces.isEmpty()) {
            return true;
        }
        String host = address.getHost();
        if (AddressUtil.matchAnyInterface(host, this.trustedInterfaces)) {
            return true;
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine(String.format("Address %s doesn't match any trusted interface", host));
        }
        return false;
    }
}

