/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.function;

import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import java.io.Serializable;
import java.util.function.Function;

@FunctionalInterface
public interface FunctionEx<T, R>
extends Function<T, R>,
Serializable {
    public R applyEx(T var1) throws Exception;

    @Override
    default public R apply(T t) {
        try {
            return this.applyEx(t);
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    public static <T> FunctionEx<T, T> identity() {
        return t -> t;
    }

    @Override
    default public <V> FunctionEx<V, R> compose(FunctionEx<? super V, ? extends T> before) {
        Preconditions.checkNotNull(before, "before");
        return v -> this.apply(before.apply((Object)v));
    }

    @Override
    default public <V> FunctionEx<T, V> andThen(FunctionEx<? super R, ? extends V> after) {
        Preconditions.checkNotNull(after, "after");
        return t -> after.apply((R)this.apply(t));
    }
}

