/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.config.EventJournalConfig;

public final class EventJournalConfigCodec {
    private static final int ENABLED_FIELD_OFFSET = 0;
    private static final int CAPACITY_FIELD_OFFSET = 1;
    private static final int TIME_TO_LIVE_SECONDS_FIELD_OFFSET = 5;
    private static final int INITIAL_FRAME_SIZE = 9;

    private EventJournalConfigCodec() {
    }

    public static void encode(ClientMessage clientMessage, EventJournalConfig eventJournalConfig) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[9]);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 0, eventJournalConfig.isEnabled());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 1, eventJournalConfig.getCapacity());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 5, eventJournalConfig.getTimeToLiveSeconds());
        clientMessage.add(initialFrame);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static EventJournalConfig decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        boolean enabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 0);
        int capacity = FixedSizeTypesCodec.decodeInt(initialFrame.content, 1);
        int timeToLiveSeconds = FixedSizeTypesCodec.decodeInt(initialFrame.content, 5);
        CodecUtil.fastForwardToEndFrame(iterator);
        return CustomTypeFactory.createEventJournalConfig(enabled, capacity, timeToLiveSeconds);
    }
}

