/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

public class ConnectionRetryConfig {
    private static final int INITIAL_BACKOFF_MILLIS = 1000;
    private static final int MAX_BACKOFF_MILLIS = 30000;
    private static final long CLUSTER_CONNECT_TIMEOUT_MILLIS = 20000L;
    private static final double JITTER = 0.0;
    private int initialBackoffMillis = 1000;
    private int maxBackoffMillis = 30000;
    private double multiplier = 1.0;
    private long connectTimeoutMillis = 20000L;
    private double jitter = 0.0;

    public ConnectionRetryConfig() {
    }

    public ConnectionRetryConfig(ConnectionRetryConfig connectionRetryConfig) {
        this.initialBackoffMillis = connectionRetryConfig.initialBackoffMillis;
        this.maxBackoffMillis = connectionRetryConfig.maxBackoffMillis;
        this.multiplier = connectionRetryConfig.multiplier;
        this.connectTimeoutMillis = connectionRetryConfig.connectTimeoutMillis;
        this.jitter = connectionRetryConfig.jitter;
    }

    public int getInitialBackoffMillis() {
        return this.initialBackoffMillis;
    }

    public ConnectionRetryConfig setInitialBackoffMillis(int initialBackoffMillis) {
        this.initialBackoffMillis = initialBackoffMillis;
        return this;
    }

    public int getMaxBackoffMillis() {
        return this.maxBackoffMillis;
    }

    public ConnectionRetryConfig setMaxBackoffMillis(int maxBackoffMillis) {
        this.maxBackoffMillis = maxBackoffMillis;
        return this;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public ConnectionRetryConfig setMultiplier(double multiplier) {
        this.multiplier = multiplier;
        return this;
    }

    public long getClusterConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public ConnectionRetryConfig setClusterConnectTimeoutMillis(long clusterConnectTimeoutMillis) {
        this.connectTimeoutMillis = clusterConnectTimeoutMillis;
        return this;
    }

    public double getJitter() {
        return this.jitter;
    }

    public ConnectionRetryConfig setJitter(double jitter) {
        this.jitter = jitter;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionRetryConfig that = (ConnectionRetryConfig)o;
        if (this.initialBackoffMillis != that.initialBackoffMillis) {
            return false;
        }
        if (this.maxBackoffMillis != that.maxBackoffMillis) {
            return false;
        }
        if (Double.compare(that.multiplier, this.multiplier) != 0) {
            return false;
        }
        if (this.connectTimeoutMillis != that.connectTimeoutMillis) {
            return false;
        }
        return Double.compare(that.jitter, this.jitter) == 0;
    }

    public int hashCode() {
        int result = this.initialBackoffMillis;
        result = 31 * result + this.maxBackoffMillis;
        long temp = Double.doubleToLongBits(this.multiplier);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (int)(this.connectTimeoutMillis ^ this.connectTimeoutMillis >>> 32);
        temp = Double.doubleToLongBits(this.jitter);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "ConnectionRetryConfig{, initialBackoffMillis=" + this.initialBackoffMillis + ", maxBackoffMillis=" + this.maxBackoffMillis + ", multiplier=" + this.multiplier + ", clusterConnectTimeoutMillis=" + this.connectTimeoutMillis + ", jitter=" + this.jitter + '}';
    }
}

