/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.internal.usercodedeployment.impl.ClassloadingMutexProvider;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.util.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;

@PrivateApi
public class FilteringClassLoader
extends ClassLoader {
    private static final int BUFFER_SIZE = 1024;
    private final ClassloadingMutexProvider mutexProvider = new ClassloadingMutexProvider();
    private final Pattern pattern = Pattern.compile("\\.");
    private final byte[] buffer = new byte[1024];
    private final List<String> excludePackages;
    private final ClassLoader delegatingClassLoader;
    private final String enforcedSelfLoadingPackage;

    public FilteringClassLoader(List<String> excludePackages, String enforcedSelfLoadingPackage) {
        this.excludePackages = Collections.unmodifiableList(excludePackages);
        this.enforcedSelfLoadingPackage = enforcedSelfLoadingPackage;
        try {
            Field parent = ClassLoader.class.getDeclaredField("parent");
            parent.setAccessible(true);
            this.delegatingClassLoader = (ClassLoader)parent.get(this);
            parent.set(this, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public URL getResource(String name) {
        return this.delegatingClassLoader.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.delegatingClassLoader.getResources(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.delegatingClassLoader.getResourceAsStream(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Preconditions.isNotNull(name, "name");
        for (String excludePackage : this.excludePackages) {
            if (!name.startsWith(excludePackage)) continue;
            throw new ClassNotFoundException(name + " - Package excluded explicitly!");
        }
        if (this.enforcedSelfLoadingPackage != null && name.startsWith(this.enforcedSelfLoadingPackage)) {
            Closeable classLoadingMutex = this.mutexProvider.getMutexForClass(name);
            try {
                Closeable closeable = classLoadingMutex;
                synchronized (closeable) {
                    Class<?> clazz = this.findLoadedClass(name);
                    if (clazz == null) {
                        clazz = this.loadAndDefineClass(name);
                    }
                    Class<?> clazz2 = clazz;
                    return clazz2;
                }
            }
            finally {
                IOUtil.closeResource(classLoadingMutex);
            }
        }
        return this.delegatingClassLoader.loadClass(name);
    }

    private Class<?> loadAndDefineClass(String name) throws ClassNotFoundException {
        Class<?> clazz;
        InputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            int length;
            is = this.getResourceAsStream(this.pattern.matcher(name).replaceAll("/").concat(".class"));
            os = new ByteArrayOutputStream();
            while ((length = is.read(this.buffer)) != -1) {
                os.write(this.buffer, 0, length);
            }
            byte[] data = os.toByteArray();
            clazz = this.defineClass(name, data, 0, data.length);
        }
        catch (Exception e) {
            try {
                throw new ClassNotFoundException(name, e);
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(os);
                IOUtil.closeResource(is);
                throw throwable;
            }
        }
        IOUtil.closeResource(os);
        IOUtil.closeResource(is);
        return clazz;
    }
}

