/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.record.AbstractReplicatedRecordStore;
import com.hazelcast.replicatedmap.impl.record.DataReplicatedRecordStore;
import com.hazelcast.replicatedmap.impl.record.ObjectReplicatedRecordStorage;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PartitionContainer {
    private final ReplicatedMapService service;
    private final int partitionId;
    private final ConcurrentHashMap<String, ReplicatedRecordStore> replicatedStorages = this.initReplicatedRecordStoreMapping();
    private final ConstructorFunction<String, ReplicatedRecordStore> constructor = this.buildConstructorFunction();

    public PartitionContainer(ReplicatedMapService service, int partitionId) {
        this.service = service;
        this.partitionId = partitionId;
    }

    private ConcurrentHashMap<String, ReplicatedRecordStore> initReplicatedRecordStoreMapping() {
        return new ConcurrentHashMap<String, ReplicatedRecordStore>();
    }

    private ConstructorFunction<String, ReplicatedRecordStore> buildConstructorFunction() {
        return new ConstructorFunction<String, ReplicatedRecordStore>(){

            @Override
            public ReplicatedRecordStore createNew(String name) {
                ReplicatedMapConfig replicatedMapConfig = PartitionContainer.this.service.getReplicatedMapConfig(name);
                InMemoryFormat inMemoryFormat = replicatedMapConfig.getInMemoryFormat();
                AbstractReplicatedRecordStore replicatedRecordStorage = null;
                switch (inMemoryFormat) {
                    case OBJECT: {
                        replicatedRecordStorage = new ObjectReplicatedRecordStorage(name, PartitionContainer.this.service, PartitionContainer.this.partitionId);
                        break;
                    }
                    case BINARY: {
                        replicatedRecordStorage = new DataReplicatedRecordStore(name, PartitionContainer.this.service, PartitionContainer.this.partitionId);
                        break;
                    }
                    case NATIVE: {
                        throw new IllegalStateException("Native memory not yet supported for replicated map");
                    }
                    default: {
                        throw new IllegalStateException("Unhandled in memory format:" + (Object)((Object)inMemoryFormat));
                    }
                }
                return replicatedRecordStorage;
            }
        };
    }

    public boolean isEmpty() {
        return this.replicatedStorages.isEmpty();
    }

    public ConcurrentMap<String, ReplicatedRecordStore> getStores() {
        return this.replicatedStorages;
    }

    public ReplicatedRecordStore getOrCreateRecordStore(String name) {
        ReplicatedRecordStore replicatedRecordStore = ConcurrencyUtil.getOrPutSynchronized(this.replicatedStorages, name, this.replicatedStorages, this.constructor);
        return replicatedRecordStore;
    }

    public ReplicatedRecordStore getRecordStore(String name) {
        return this.replicatedStorages.get(name);
    }

    public void shutdown() {
        for (ReplicatedRecordStore replicatedRecordStore : this.replicatedStorages.values()) {
            replicatedRecordStore.destroy();
        }
        this.replicatedStorages.clear();
    }

    public void destroy(String name) {
        ReplicatedRecordStore replicatedRecordStore = this.replicatedStorages.remove(name);
        if (replicatedRecordStore != null) {
            replicatedRecordStore.destroy();
        }
    }
}

