/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor.impl.operations;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.executor.impl.DistributedExecutorService;
import com.hazelcast.executor.impl.ExecutorDataSerializerHook;
import com.hazelcast.executor.impl.RunnableAdapter;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.util.concurrent.Callable;

abstract class AbstractCallableTaskOperation
extends Operation
implements IdentifiedDataSerializable {
    protected String name;
    protected String uuid;
    protected transient Callable callable;
    private Data callableData;
    private boolean returnsResponse = true;

    public AbstractCallableTaskOperation() {
    }

    public AbstractCallableTaskOperation(String name, String uuid, Data callableData) {
        this.name = name;
        this.uuid = uuid;
        this.callableData = callableData;
    }

    @Override
    public final void beforeRun() throws Exception {
        this.returnsResponse = false;
        this.callable = this.getCallable();
        ManagedContext managedContext = this.getManagedContext();
        if (this.callable instanceof RunnableAdapter) {
            RunnableAdapter adapter = (RunnableAdapter)this.callable;
            Runnable runnable = (Runnable)managedContext.initialize(adapter.getRunnable());
            adapter.setRunnable(runnable);
        } else {
            this.callable = (Callable)managedContext.initialize(this.callable);
        }
    }

    private Callable getCallable() {
        try {
            return (Callable)this.getNodeEngine().toObject(this.callableData);
        }
        catch (HazelcastSerializationException e) {
            this.sendResponse(e);
            throw ExceptionUtil.rethrow(e);
        }
    }

    private ManagedContext getManagedContext() {
        HazelcastInstanceImpl hazelcastInstance = (HazelcastInstanceImpl)this.getNodeEngine().getHazelcastInstance();
        InternalSerializationService serializationService = hazelcastInstance.getSerializationService();
        return serializationService.getManagedContext();
    }

    @Override
    public final void run() throws Exception {
        DistributedExecutorService service = (DistributedExecutorService)this.getService();
        service.execute(this.name, this.uuid, this.callable, this);
    }

    @Override
    public final boolean returnsResponse() {
        return this.returnsResponse;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:executorService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.uuid);
        out.writeData(this.callableData);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.uuid = in.readUTF();
        this.callableData = in.readData();
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", name=").append(this.name);
    }

    @Override
    public int getFactoryId() {
        return ExecutorDataSerializerHook.F_ID;
    }
}

