/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.schemawiring;

import graphql.GraphQLError;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLType;
import graphql.validation.interpolation.MessageInterpolator;
import graphql.validation.rules.OnValidationErrorStrategy;
import graphql.validation.rules.TargetedValidationRules;
import graphql.validation.rules.ValidationRules;
import graphql.validation.util.Util;
import java.util.List;
import java.util.Locale;

public class FieldValidatorDataFetcher
implements DataFetcher<Object> {
    private final OnValidationErrorStrategy errorStrategy;
    private final MessageInterpolator messageInterpolator;
    private final DataFetcher<?> defaultDataFetcher;
    private final Locale defaultLocale;
    private final ValidationRules validationRules;
    private TargetedValidationRules applicableRules;

    public FieldValidatorDataFetcher(OnValidationErrorStrategy errorStrategy, MessageInterpolator messageInterpolator, DataFetcher<?> defaultDataFetcher, Locale defaultLocale, ValidationRules validationRules) {
        this.errorStrategy = errorStrategy;
        this.messageInterpolator = messageInterpolator;
        this.defaultDataFetcher = defaultDataFetcher;
        this.defaultLocale = defaultLocale;
        this.validationRules = validationRules;
        this.applicableRules = null;
    }

    public Object get(DataFetchingEnvironment environment) throws Exception {
        if (!this.wereApplicableRulesFetched()) {
            this.fetchApplicableRules(environment);
        }
        if (this.applicableRules.isEmpty()) {
            return this.defaultDataFetcher.get(environment);
        }
        List<GraphQLError> errors = this.applicableRules.runValidationRules(environment, this.messageInterpolator, this.defaultLocale);
        if (!errors.isEmpty() && !this.errorStrategy.shouldContinue(errors, environment)) {
            return this.errorStrategy.onErrorValue(errors, environment);
        }
        Object returnValue = this.defaultDataFetcher.get(environment);
        if (errors.isEmpty()) {
            return returnValue;
        }
        return Util.mkDFRFromFetchedResult(errors, returnValue);
    }

    private void fetchApplicableRules(DataFetchingEnvironment environment) {
        GraphQLFieldDefinition field = environment.getFieldDefinition();
        GraphQLFieldsContainer container = this.asContainer(environment);
        this.applicableRules = this.validationRules.buildRulesFor(field, container);
    }

    private GraphQLFieldsContainer asContainer(DataFetchingEnvironment environment) {
        GraphQLType parent = environment.getParentType();
        if (parent == null) {
            return null;
        }
        return (GraphQLFieldsContainer)environment.getParentType();
    }

    private boolean wereApplicableRulesFetched() {
        return this.applicableRules != null;
    }
}

