/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.GraphQLContext;
import graphql.PublicApi;
import graphql.execution.ResultPath;
import graphql.language.SourceLocation;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputType;
import graphql.validation.interpolation.MessageInterpolator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class ValidationEnvironment {
    private final GraphQLFieldsContainer fieldsContainer;
    private final GraphQLFieldDefinition fieldDefinition;
    private final GraphQLArgument argument;
    private final ResultPath executionPath;
    private final ResultPath validatedPath;
    private final SourceLocation location;
    private final MessageInterpolator interpolator;
    private final Map<Class, Object> contextMap;
    private final Locale locale;
    private final Map<String, Object> argumentValues;
    private final Object validatedValue;
    private final GraphQLInputType validatedType;
    private final ValidatedElement validatedElement;
    private final GraphQLContext graphQLContext;
    private final List<GraphQLAppliedDirective> directives;

    private ValidationEnvironment(Builder builder) {
        this.argument = builder.argument;
        this.argumentValues = Collections.unmodifiableMap(builder.argumentValues);
        this.contextMap = Collections.unmodifiableMap(builder.contextMap);
        this.fieldDefinition = builder.fieldDefinition;
        this.executionPath = builder.executionPath;
        this.validatedPath = builder.validatedPath;
        this.validatedType = builder.validatedType;
        this.fieldsContainer = builder.fieldsContainer;
        this.interpolator = builder.interpolator;
        this.locale = builder.locale;
        this.location = builder.location;
        this.validatedValue = builder.validatedValue;
        this.validatedElement = builder.validatedElement;
        this.graphQLContext = builder.graphQLContext;
        this.directives = builder.directives;
    }

    public static Builder newValidationEnvironment() {
        return new Builder();
    }

    public <T> T getContextObject(Class<T> clazz, Object ... defaultVal) {
        return this.contextMap.getOrDefault(clazz, defaultVal.length == 0 ? null : defaultVal[0]);
    }

    public GraphQLFieldsContainer getFieldsContainer() {
        return this.fieldsContainer;
    }

    public GraphQLFieldDefinition getFieldDefinition() {
        return this.fieldDefinition;
    }

    public GraphQLArgument getArgument() {
        return this.argument;
    }

    public SourceLocation getLocation() {
        return this.location;
    }

    public ResultPath getValidatedPath() {
        return this.validatedPath;
    }

    public ResultPath getExecutionPath() {
        return this.executionPath;
    }

    public GraphQLInputType getValidatedType() {
        return this.validatedType;
    }

    public Object getValidatedValue() {
        return this.validatedValue;
    }

    public Map<String, Object> getArgumentValues() {
        return this.argumentValues;
    }

    public MessageInterpolator getInterpolator() {
        return this.interpolator;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ValidatedElement getValidatedElement() {
        return this.validatedElement;
    }

    public List<GraphQLAppliedDirective> getDirectives() {
        return this.directives;
    }

    public GraphQLContext getGraphQLContext() {
        return this.graphQLContext;
    }

    public ValidationEnvironment transform(Consumer<Builder> builderConsumer) {
        Builder builder = ValidationEnvironment.newValidationEnvironment().validationEnvironment(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static class Builder {
        private final Map<Class, Object> contextMap = new HashMap<Class, Object>();
        private GraphQLArgument argument;
        private Map<String, Object> argumentValues = new HashMap<String, Object>();
        private GraphQLFieldDefinition fieldDefinition;
        private ResultPath validatedPath = ResultPath.rootPath();
        private ResultPath executionPath;
        private GraphQLFieldsContainer fieldsContainer;
        private MessageInterpolator interpolator;
        private Locale locale;
        private SourceLocation location;
        private Object validatedValue;
        private GraphQLInputType validatedType;
        private ValidatedElement validatedElement;
        private List<GraphQLAppliedDirective> directives = Collections.emptyList();
        private GraphQLContext graphQLContext = GraphQLContext.getDefault();

        public Builder validationEnvironment(ValidationEnvironment validationEnvironment) {
            this.argument = validationEnvironment.argument;
            this.argumentValues = validationEnvironment.argumentValues;
            this.contextMap.putAll(validationEnvironment.contextMap);
            this.fieldDefinition = validationEnvironment.fieldDefinition;
            this.executionPath = validationEnvironment.executionPath;
            this.validatedPath = validationEnvironment.validatedPath;
            this.validatedType = validationEnvironment.validatedType;
            this.fieldsContainer = validationEnvironment.fieldsContainer;
            this.interpolator = validationEnvironment.interpolator;
            this.locale = validationEnvironment.locale;
            this.location = validationEnvironment.location;
            this.validatedValue = validationEnvironment.validatedValue;
            this.validatedElement = validationEnvironment.validatedElement;
            this.directives = validationEnvironment.directives;
            this.graphQLContext = validationEnvironment.graphQLContext;
            return this;
        }

        public Builder dataFetchingEnvironment(DataFetchingEnvironment dataFetchingEnvironment) {
            this.fieldsContainer((GraphQLFieldsContainer)dataFetchingEnvironment.getExecutionStepInfo().getObjectType());
            this.fieldDefinition(dataFetchingEnvironment.getFieldDefinition());
            this.directives(dataFetchingEnvironment.getFieldDefinition().getAppliedDirectives());
            this.executionPath(dataFetchingEnvironment.getExecutionStepInfo().getPath());
            this.validatedPath(dataFetchingEnvironment.getExecutionStepInfo().getPath());
            this.location(dataFetchingEnvironment.getField().getSourceLocation());
            this.argumentValues(dataFetchingEnvironment.getArguments());
            this.validatedElement(ValidatedElement.FIELD);
            this.graphQLContext(dataFetchingEnvironment.getGraphQlContext());
            return this;
        }

        public Builder argument(GraphQLArgument argument) {
            this.argument = argument;
            return this;
        }

        public Builder context(Class clazz, Object value) {
            this.contextMap.put(clazz, value);
            return this;
        }

        public Builder fieldsContainer(GraphQLFieldsContainer fieldsContainer) {
            this.fieldsContainer = fieldsContainer;
            return this;
        }

        public Builder executionPath(ResultPath executionPath) {
            this.executionPath = executionPath;
            return this;
        }

        public Builder fieldDefinition(GraphQLFieldDefinition fieldDefinition) {
            this.fieldDefinition = fieldDefinition;
            return this;
        }

        public Builder validatedElement(ValidatedElement validatedElement) {
            this.validatedElement = validatedElement;
            return this;
        }

        public Builder validatedType(GraphQLInputType validatedType) {
            this.validatedType = validatedType;
            return this;
        }

        public Builder validatedValue(Object validatedValue) {
            this.validatedValue = validatedValue;
            return this;
        }

        public Builder validatedPath(ResultPath validatedPath) {
            this.validatedPath = validatedPath;
            return this;
        }

        public Builder argumentValues(Map<String, Object> argumentValues) {
            this.argumentValues = argumentValues;
            return this;
        }

        public Builder location(SourceLocation location) {
            this.location = location;
            return this;
        }

        public Builder messageInterpolator(MessageInterpolator interpolator) {
            this.interpolator = interpolator;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder graphQLContext(GraphQLContext graphQLContext) {
            this.graphQLContext = graphQLContext;
            return this;
        }

        public Builder directives(List<GraphQLAppliedDirective> directives) {
            this.directives = directives;
            return this;
        }

        public ValidationEnvironment build() {
            return new ValidationEnvironment(this);
        }
    }

    public static enum ValidatedElement {
        FIELD,
        ARGUMENT,
        INPUT_OBJECT_FIELD;

    }
}

