/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.spring.error;

import graphql.ExceptionWhileDataFetching;
import graphql.GraphQLError;
import graphql.GraphQLException;
import graphql.GraphqlErrorBuilder;
import graphql.SerializationError;
import graphql.kickstart.execution.error.DefaultGraphQLErrorHandler;
import graphql.kickstart.spring.error.ErrorContext;
import graphql.kickstart.spring.error.GraphQLErrorFactory;
import graphql.kickstart.spring.error.ThrowableComparator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GraphQLErrorFromExceptionHandler
extends DefaultGraphQLErrorHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphQLErrorFromExceptionHandler.class);
    private final List<GraphQLErrorFactory> factories;

    GraphQLErrorFromExceptionHandler(List<GraphQLErrorFactory> factories) {
        this.factories = factories;
    }

    protected List<GraphQLError> filterGraphQLErrors(List<GraphQLError> errors) {
        return errors.stream().map(this::transform).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Collection<GraphQLError> transform(GraphQLError error) {
        ErrorContext errorContext = new ErrorContext(error.getLocations(), error.getPath(), error.getExtensions(), error.getErrorType());
        return this.extractException(error).map(throwable -> this.transform((Throwable)throwable, errorContext)).orElse(Collections.singletonList(error));
    }

    private Optional<Throwable> extractException(GraphQLError error) {
        if (error instanceof ExceptionWhileDataFetching) {
            return Optional.of(((ExceptionWhileDataFetching)error).getException());
        }
        if (error instanceof SerializationError) {
            return Optional.of(((SerializationError)error).getException());
        }
        if (error instanceof GraphQLException) {
            return Optional.of((GraphQLException)error);
        }
        return Optional.empty();
    }

    private Collection<GraphQLError> transform(Throwable throwable, ErrorContext errorContext) {
        HashMap applicables = new HashMap();
        this.factories.forEach(factory -> factory.mostConcrete(throwable).ifPresent(t -> applicables.put(t, factory)));
        return applicables.keySet().stream().min(new ThrowableComparator()).map(applicables::get).map(factory -> factory.create(throwable, errorContext)).orElseGet(() -> this.withThrowable(throwable, errorContext));
    }

    private Collection<GraphQLError> withThrowable(Throwable throwable, ErrorContext errorContext) {
        Map extensions = Optional.ofNullable(errorContext.getExtensions()).orElseGet(HashMap::new);
        extensions.put("type", throwable.getClass().getSimpleName());
        GraphqlErrorBuilder builder = GraphqlErrorBuilder.newError().extensions(extensions);
        Optional.ofNullable(throwable.getMessage()).ifPresent(x$0 -> builder.message(x$0, new Object[0]));
        Optional.ofNullable(errorContext.getErrorType()).ifPresent(arg_0 -> ((GraphqlErrorBuilder)builder).errorType(arg_0));
        Optional.ofNullable(errorContext.getLocations()).ifPresent(arg_0 -> ((GraphqlErrorBuilder)builder).locations(arg_0));
        Optional.ofNullable(errorContext.getPath()).ifPresent(arg_0 -> ((GraphqlErrorBuilder)builder).path(arg_0));
        return Collections.singletonList(builder.build());
    }

    @Generated
    public List<GraphQLErrorFactory> getFactories() {
        return this.factories;
    }
}

