/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Converter;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MutableClassToInstanceMap;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Parameter;
import com.google.common.reflect.Reflection;
import com.google.common.reflect.TypeToken;
import com.google.common.testing.ArbitraryInstances;
import com.google.common.testing.DummyProxy;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

@Beta
@GwtIncompatible
public final class NullPointerTester {
    private final ClassToInstanceMap<Object> defaults = MutableClassToInstanceMap.create();
    private final List<Member> ignoredMembers = Lists.newArrayList();
    private ExceptionTypePolicy policy = ExceptionTypePolicy.NPE_OR_UOE;

    public <T> NullPointerTester setDefault(Class<T> type, T value) {
        this.defaults.putInstance(type, Preconditions.checkNotNull(value));
        return this;
    }

    public NullPointerTester ignore(Method method) {
        this.ignoredMembers.add((Member)Preconditions.checkNotNull((Object)method));
        return this;
    }

    public NullPointerTester ignore(Constructor<?> constructor) {
        this.ignoredMembers.add((Member)Preconditions.checkNotNull(constructor));
        return this;
    }

    public void testConstructors(Class<?> c, Visibility minimalVisibility) {
        for (Constructor<?> constructor : c.getDeclaredConstructors()) {
            if (!minimalVisibility.isVisible(constructor) || this.isIgnored(constructor)) continue;
            this.testConstructor(constructor);
        }
    }

    public void testAllPublicConstructors(Class<?> c) {
        this.testConstructors(c, Visibility.PUBLIC);
    }

    public void testStaticMethods(Class<?> c, Visibility minimalVisibility) {
        for (Method method : minimalVisibility.getStaticMethods(c)) {
            if (this.isIgnored(method)) continue;
            this.testMethod(null, method);
        }
    }

    public void testAllPublicStaticMethods(Class<?> c) {
        this.testStaticMethods(c, Visibility.PUBLIC);
    }

    public void testInstanceMethods(Object instance, Visibility minimalVisibility) {
        for (Method method : this.getInstanceMethodsToTest(instance.getClass(), minimalVisibility)) {
            this.testMethod(instance, method);
        }
    }

    ImmutableList<Method> getInstanceMethodsToTest(Class<?> c, Visibility minimalVisibility) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Method method : minimalVisibility.getInstanceMethods(c)) {
            if (this.isIgnored(method)) continue;
            builder.add((Object)method);
        }
        return builder.build();
    }

    public void testAllPublicInstanceMethods(Object instance) {
        this.testInstanceMethods(instance, Visibility.PUBLIC);
    }

    public void testMethod(@Nullable Object instance, Method method) {
        Class<?>[] types = method.getParameterTypes();
        for (int nullIndex = 0; nullIndex < types.length; ++nullIndex) {
            this.testMethodParameter(instance, method, nullIndex);
        }
    }

    public void testConstructor(Constructor<?> ctor) {
        Class<?> declaringClass = ctor.getDeclaringClass();
        Preconditions.checkArgument((Modifier.isStatic(declaringClass.getModifiers()) || declaringClass.getEnclosingClass() == null ? 1 : 0) != 0, (String)"Cannot test constructor of non-static inner class: %s", (Object)declaringClass.getName());
        Class<?>[] types = ctor.getParameterTypes();
        for (int nullIndex = 0; nullIndex < types.length; ++nullIndex) {
            this.testConstructorParameter(ctor, nullIndex);
        }
    }

    public void testMethodParameter(@Nullable Object instance, Method method, int paramIndex) {
        method.setAccessible(true);
        this.testParameter(instance, NullPointerTester.invokable(instance, method), paramIndex, method.getDeclaringClass());
    }

    public void testConstructorParameter(Constructor<?> ctor, int paramIndex) {
        ctor.setAccessible(true);
        this.testParameter(null, Invokable.from(ctor), paramIndex, ctor.getDeclaringClass());
    }

    private void testParameter(Object instance, Invokable<?, ?> invokable, int paramIndex, Class<?> testedClass) {
        if (NullPointerTester.isPrimitiveOrNullable((Parameter)invokable.getParameters().get(paramIndex))) {
            return;
        }
        Object[] params = this.buildParamList(invokable, paramIndex);
        try {
            Invokable<?, ?> unsafe = invokable;
            unsafe.invoke(instance, params);
            Assert.fail((String)("No exception thrown for parameter at index " + paramIndex + " from " + invokable + Arrays.toString(params) + " for " + testedClass));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (this.policy.isExpectedType(cause)) {
                return;
            }
            AssertionFailedError error = new AssertionFailedError(String.format("wrong exception thrown from %s when passing null to %s parameter at index %s.%nFull parameters: %s%nActual exception message: %s", invokable, ((Parameter)invokable.getParameters().get(paramIndex)).getType(), paramIndex, Arrays.toString(params), cause));
            error.initCause(cause);
            throw error;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Object[] buildParamList(Invokable<?, ?> invokable, int indexOfParamToSetToNull) {
        ImmutableList params = invokable.getParameters();
        Object[] args = new Object[params.size()];
        for (int i = 0; i < args.length; ++i) {
            Parameter param = (Parameter)params.get(i);
            if (i == indexOfParamToSetToNull) continue;
            args[i] = this.getDefaultValue(param.getType());
            Assert.assertTrue((String)("Can't find or create a sample instance for type '" + param.getType() + "'; please provide one using NullPointerTester.setDefault()"), (args[i] != null || NullPointerTester.isNullable(param) ? 1 : 0) != 0);
        }
        return args;
    }

    private <T> T getDefaultValue(TypeToken<T> type) {
        Object defaultValue = this.defaults.getInstance(type.getRawType());
        if (defaultValue != null) {
            return (T)defaultValue;
        }
        Object arbitrary = ArbitraryInstances.get(type.getRawType());
        if (arbitrary != null) {
            return arbitrary;
        }
        if (type.getRawType() == Class.class) {
            Class defaultClass = NullPointerTester.getFirstTypeParameter(type.getType()).getRawType();
            return (T)defaultClass;
        }
        if (type.getRawType() == TypeToken.class) {
            TypeToken<?> defaultType = NullPointerTester.getFirstTypeParameter(type.getType());
            return (T)defaultType;
        }
        if (type.getRawType() == Converter.class) {
            TypeToken convertFromType = type.resolveType(Converter.class.getTypeParameters()[0]);
            TypeToken convertToType = type.resolveType(Converter.class.getTypeParameters()[1]);
            Converter defaultConverter = this.defaultConverter(convertFromType, convertToType);
            return (T)defaultConverter;
        }
        if (type.getRawType().isInterface()) {
            return this.newDefaultReturningProxy(type);
        }
        return null;
    }

    private <F, T> Converter<F, T> defaultConverter(final TypeToken<F> convertFromType, final TypeToken<T> convertToType) {
        return new Converter<F, T>(){

            protected T doForward(F a) {
                return this.doConvert(convertToType);
            }

            protected F doBackward(T b) {
                return this.doConvert(convertFromType);
            }

            private <S> S doConvert(TypeToken<S> type) {
                return (S)Preconditions.checkNotNull((Object)NullPointerTester.this.getDefaultValue(type));
            }
        };
    }

    private static TypeToken<?> getFirstTypeParameter(Type type) {
        if (type instanceof ParameterizedType) {
            return TypeToken.of((Type)((ParameterizedType)type).getActualTypeArguments()[0]);
        }
        return TypeToken.of(Object.class);
    }

    private <T> T newDefaultReturningProxy(TypeToken<T> type) {
        return new DummyProxy(){

            @Override
            <R> R dummyReturnValue(TypeToken<R> returnType) {
                return (R)NullPointerTester.this.getDefaultValue(returnType);
            }
        }.newProxy(type);
    }

    private static Invokable<?, ?> invokable(@Nullable Object instance, Method method) {
        if (instance == null) {
            return Invokable.from((Method)method);
        }
        return TypeToken.of(instance.getClass()).method(method);
    }

    static boolean isPrimitiveOrNullable(Parameter param) {
        return param.getType().getRawType().isPrimitive() || NullPointerTester.isNullable(param);
    }

    private static boolean isNullable(Parameter param) {
        return param.isAnnotationPresent(CheckForNull.class) || param.isAnnotationPresent(Nullable.class);
    }

    private boolean isIgnored(Member member) {
        return member.isSynthetic() || this.ignoredMembers.contains(member) || NullPointerTester.isEquals(member);
    }

    private static boolean isEquals(Member member) {
        if (!(member instanceof Method)) {
            return false;
        }
        Method method = (Method)member;
        if (!method.getName().contentEquals("equals")) {
            return false;
        }
        Class<?>[] parameters = method.getParameterTypes();
        if (parameters.length != 1) {
            return false;
        }
        return parameters[0].equals(Object.class);
    }

    private static enum ExceptionTypePolicy {
        NPE_OR_UOE{

            @Override
            public boolean isExpectedType(Throwable cause) {
                return cause instanceof NullPointerException || cause instanceof UnsupportedOperationException;
            }
        }
        ,
        NPE_IAE_OR_UOE{

            @Override
            public boolean isExpectedType(Throwable cause) {
                return cause instanceof NullPointerException || cause instanceof IllegalArgumentException || cause instanceof UnsupportedOperationException;
            }
        };


        public abstract boolean isExpectedType(Throwable var1);
    }

    private static final class Signature {
        private final String name;
        private final ImmutableList<Class<?>> parameterTypes;

        Signature(Method method) {
            this(method.getName(), ImmutableList.copyOf((Object[])method.getParameterTypes()));
        }

        Signature(String name, ImmutableList<Class<?>> parameterTypes) {
            this.name = name;
            this.parameterTypes = parameterTypes;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Signature) {
                Signature that = (Signature)obj;
                return this.name.equals(that.name) && this.parameterTypes.equals(that.parameterTypes);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.parameterTypes});
        }
    }

    public static enum Visibility {
        PACKAGE{

            @Override
            boolean isVisible(int modifiers) {
                return !Modifier.isPrivate(modifiers);
            }
        }
        ,
        PROTECTED{

            @Override
            boolean isVisible(int modifiers) {
                return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers);
            }
        }
        ,
        PUBLIC{

            @Override
            boolean isVisible(int modifiers) {
                return Modifier.isPublic(modifiers);
            }
        };


        abstract boolean isVisible(int var1);

        final boolean isVisible(Member member) {
            return this.isVisible(member.getModifiers());
        }

        final Iterable<Method> getStaticMethods(Class<?> cls) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Method method : this.getVisibleMethods(cls)) {
                if (!Invokable.from((Method)method).isStatic()) continue;
                builder.add((Object)method);
            }
            return builder.build();
        }

        final Iterable<Method> getInstanceMethods(Class<?> cls) {
            ConcurrentMap map = Maps.newConcurrentMap();
            for (Method method : this.getVisibleMethods(cls)) {
                if (Invokable.from((Method)method).isStatic()) continue;
                map.putIfAbsent(new Signature(method), method);
            }
            return map.values();
        }

        private ImmutableList<Method> getVisibleMethods(Class<?> cls) {
            Class type;
            String visiblePackage = Reflection.getPackageName(cls);
            ImmutableList.Builder builder = ImmutableList.builder();
            Iterator iterator = TypeToken.of(cls).getTypes().rawTypes().iterator();
            while (iterator.hasNext() && Reflection.getPackageName((Class)(type = (Class)iterator.next())).equals(visiblePackage)) {
                for (Method method : type.getDeclaredMethods()) {
                    if (method.isSynthetic() || !this.isVisible(method)) continue;
                    builder.add((Object)method);
                }
            }
            return builder.build();
        }
    }
}

