/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.firebase.internal.NonNull;
import com.google.firebase.remoteconfig.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Value {
    private static final Logger logger = LoggerFactory.getLogger(Value.class);
    private static final boolean DEFAULT_VALUE_FOR_BOOLEAN = false;
    private static final String DEFAULT_VALUE_FOR_STRING = "";
    private static final long DEFAULT_VALUE_FOR_LONG = 0L;
    private static final double DEFAULT_VALUE_FOR_DOUBLE = 0.0;
    private static final ImmutableList<String> BOOLEAN_TRUTHY_VALUES = ImmutableList.of((Object)"1", (Object)"true", (Object)"t", (Object)"yes", (Object)"y", (Object)"on");
    private final ValueSource source;
    private final String value;

    Value(@NonNull ValueSource source, String value) {
        Preconditions.checkNotNull((Object)((Object)source), (Object)"Value source cannot be null.");
        this.source = source;
        this.value = value;
    }

    Value(@NonNull ValueSource source) {
        this(source, DEFAULT_VALUE_FOR_STRING);
    }

    @NonNull
    String asString() {
        return this.value;
    }

    @NonNull
    boolean asBoolean() {
        if (this.source == ValueSource.STATIC) {
            return false;
        }
        return BOOLEAN_TRUTHY_VALUES.contains((Object)this.value.toLowerCase());
    }

    @NonNull
    long asLong() {
        if (this.source == ValueSource.STATIC) {
            return 0L;
        }
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException e) {
            logger.warn("Unable to convert {} to long type.", (Object)this.value);
            return 0L;
        }
    }

    @NonNull
    double asDouble() {
        if (this.source == ValueSource.STATIC) {
            return 0.0;
        }
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            logger.warn("Unable to convert {} to double type.", (Object)this.value);
            return 0.0;
        }
    }

    @NonNull
    ValueSource getSource() {
        return this.source;
    }
}

