/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.internal.NonNull;
import com.google.firebase.remoteconfig.Value;
import com.google.firebase.remoteconfig.ValueSource;
import java.util.Map;

public final class ServerConfig {
    private final Map<String, Value> configValues;

    ServerConfig(Map<String, Value> configValues) {
        this.configValues = configValues;
    }

    @NonNull
    public String getString(@NonNull String key) {
        return this.getValue(key).asString();
    }

    @NonNull
    public boolean getBoolean(@NonNull String key) {
        return this.getValue(key).asBoolean();
    }

    @NonNull
    public long getLong(@NonNull String key) {
        return this.getValue(key).asLong();
    }

    @NonNull
    public double getDouble(@NonNull String key) {
        return this.getValue(key).asDouble();
    }

    @NonNull
    public ValueSource getValueSource(@NonNull String key) {
        return this.getValue(key).getSource();
    }

    private Value getValue(String key) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"Server config key cannot be null or empty.");
        if (this.configValues.containsKey(key)) {
            return this.configValues.get(key);
        }
        return new Value(ValueSource.STATIC);
    }
}

