/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.internal.NonNull;
import java.util.HashMap;
import java.util.Map;

public class KeysAndValues {
    final ImmutableMap<String, String> keysAndValues;

    private KeysAndValues(@NonNull Builder builder) {
        this.keysAndValues = ImmutableMap.builder().putAll(builder.keysAndValues).build();
    }

    public boolean containsKey(String key) {
        return this.keysAndValues.containsKey((Object)key);
    }

    public String get(String key) {
        return (String)this.keysAndValues.get((Object)key);
    }

    public static class Builder {
        private final Map<String, String> keysAndValues = new HashMap<String, String>();

        @NonNull
        public Builder put(@NonNull String key, @NonNull String value) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"Context key must not be null or empty.");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0, (Object)"Context key must not be null or empty.");
            this.keysAndValues.put(key, value);
            return this;
        }

        @NonNull
        public Builder put(@NonNull String key, boolean value) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"Context key must not be null or empty.");
            this.keysAndValues.put(key, Boolean.toString(value));
            return this;
        }

        @NonNull
        public Builder put(@NonNull String key, double value) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"Context key must not be null or empty.");
            this.keysAndValues.put(key, Double.toString(value));
            return this;
        }

        @NonNull
        public Builder put(@NonNull String key, long value) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"Context key must not be null or empty.");
            this.keysAndValues.put(key, Long.toString(value));
            return this;
        }

        @NonNull
        public KeysAndValues build() {
            return new KeysAndValues(this);
        }
    }
}

