/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.prf.Prf;
import com.google.crypto.tink.subtle.AesUtil;
import com.google.crypto.tink.subtle.Bytes;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Validators;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

@Immutable
public final class PrfAesCmac
implements Prf {
    private final SecretKey keySpec;
    private byte[] subKey1;
    private byte[] subKey2;

    private static Cipher instance() throws GeneralSecurityException {
        return EngineFactory.CIPHER.getInstance("AES/ECB/NoPadding");
    }

    public PrfAesCmac(byte[] key) throws GeneralSecurityException {
        Validators.validateAesKeySize(key.length);
        this.keySpec = new SecretKeySpec(key, "AES");
        this.generateSubKeys();
    }

    @Override
    public byte[] compute(byte[] data, int outputLength) throws GeneralSecurityException {
        byte[] y;
        if (outputLength > 16) {
            throw new InvalidAlgorithmParameterException("outputLength too large, max is 16 bytes");
        }
        Cipher aes = PrfAesCmac.instance();
        aes.init(1, this.keySpec);
        int n = Math.max(1, (int)Math.ceil((double)data.length / 16.0));
        boolean flag = n * 16 == data.length;
        byte[] mLast = flag ? Bytes.xor(data, (n - 1) * 16, this.subKey1, 0, 16) : Bytes.xor(AesUtil.cmacPad(Arrays.copyOfRange(data, (n - 1) * 16, data.length)), this.subKey2);
        byte[] x = new byte[16];
        for (int i = 0; i < n - 1; ++i) {
            y = Bytes.xor(x, 0, data, i * 16, 16);
            x = aes.doFinal(y);
        }
        y = Bytes.xor(mLast, x);
        byte[] output = Arrays.copyOf(aes.doFinal(y), outputLength);
        return output;
    }

    private void generateSubKeys() throws GeneralSecurityException {
        Cipher aes = PrfAesCmac.instance();
        aes.init(1, this.keySpec);
        byte[] zeroes = new byte[16];
        byte[] l = aes.doFinal(zeroes);
        this.subKey1 = AesUtil.dbl(l);
        this.subKey2 = AesUtil.dbl(this.subKey1);
    }
}

