/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven.skaffold;

import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.plugins.common.SkaffoldInitOutput;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="_skaffold-init", requiresDependencyCollection=ResolutionScope.NONE)
public class InitMojo
extends JibPluginConfiguration {
    @VisibleForTesting
    static final String GOAL_NAME = "_skaffold-init";

    public void execute() throws MojoExecutionException {
        this.checkJibVersion();
        MavenProject project = this.getProject();
        if ("pom".equals(project.getPackaging())) {
            return;
        }
        SkaffoldInitOutput skaffoldInitOutput = new SkaffoldInitOutput();
        skaffoldInitOutput.setImage(this.getTargetImage());
        skaffoldInitOutput.setProject(project.getGroupId() + ":" + project.getArtifactId());
        System.out.println();
        System.out.println("BEGIN JIB JSON");
        try {
            System.out.println(skaffoldInitOutput.getJsonString());
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }
}

