/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.configuration;

import com.google.cloud.tools.jib.api.CredentialRetriever;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class ImageConfiguration {
    private final ImageReference image;
    private final ImmutableList<CredentialRetriever> credentialRetrievers;
    @Nullable
    private DockerClient dockerClient;
    @Nullable
    private Path tarPath;

    public static Builder builder(ImageReference imageReference) {
        return new Builder(imageReference);
    }

    private ImageConfiguration(ImageReference image, ImmutableList<CredentialRetriever> credentialRetrievers, @Nullable DockerClient dockerClient, @Nullable Path tarPath) {
        this.image = image;
        this.credentialRetrievers = credentialRetrievers;
        this.dockerClient = dockerClient;
        this.tarPath = tarPath;
    }

    public ImageReference getImage() {
        return this.image;
    }

    public String getImageRegistry() {
        return this.image.getRegistry();
    }

    public String getImageRepository() {
        return this.image.getRepository();
    }

    public String getImageQualifier() {
        return this.image.getQualifier();
    }

    public ImmutableList<CredentialRetriever> getCredentialRetrievers() {
        return this.credentialRetrievers;
    }

    public Optional<DockerClient> getDockerClient() {
        return Optional.ofNullable(this.dockerClient);
    }

    public Optional<Path> getTarPath() {
        return Optional.ofNullable(this.tarPath);
    }

    public static class Builder {
        private ImageReference imageReference;
        private ImmutableList<CredentialRetriever> credentialRetrievers = ImmutableList.of();
        @Nullable
        private DockerClient dockerClient;
        @Nullable
        private Path tarPath;

        public Builder setCredentialRetrievers(List<CredentialRetriever> credentialRetrievers) {
            Preconditions.checkArgument((boolean)credentialRetrievers.stream().allMatch(Objects::nonNull), (Object)"credential retriever list contains null elements");
            this.credentialRetrievers = ImmutableList.copyOf(credentialRetrievers);
            return this;
        }

        public Builder setDockerClient(DockerClient dockerClient) {
            this.dockerClient = dockerClient;
            return this;
        }

        public Builder setTarPath(Path tarPath) {
            this.tarPath = tarPath;
            return this;
        }

        public ImageConfiguration build() {
            int numArguments = 0;
            if (!this.credentialRetrievers.isEmpty()) {
                ++numArguments;
            }
            if (this.dockerClient != null) {
                ++numArguments;
            }
            if (this.tarPath != null) {
                ++numArguments;
            }
            Preconditions.checkArgument((numArguments <= 1 ? 1 : 0) != 0);
            return new ImageConfiguration(this.imageReference, this.credentialRetrievers, this.dockerClient, this.tarPath);
        }

        private Builder(ImageReference imageReference) {
            this.imageReference = imageReference;
        }
    }
}

