/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.datastore;

import com.google.cloud.spring.autoconfigure.datastore.DatastoreProvider;
import com.google.cloud.spring.data.datastore.core.DatastoreTransactionManager;
import java.util.function.Supplier;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.transaction.TransactionAutoConfiguration;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={DatastoreTransactionManager.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.datastore.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={TransactionAutoConfiguration.class})
public class DatastoreTransactionManagerAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    static class DatastoreTransactionManagerConfiguration {
        private final DatastoreProvider datastore;
        private final TransactionManagerCustomizers transactionManagerCustomizers;

        DatastoreTransactionManagerConfiguration(DatastoreProvider datastore, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
            this.datastore = datastore;
            this.transactionManagerCustomizers = (TransactionManagerCustomizers)transactionManagerCustomizers.getIfAvailable();
        }

        @Bean
        @ConditionalOnMissingBean(value={PlatformTransactionManager.class})
        public DatastoreTransactionManager datastoreTransactionManager() {
            DatastoreTransactionManager transactionManager = new DatastoreTransactionManager((Supplier)this.datastore);
            if (this.transactionManagerCustomizers != null) {
                this.transactionManagerCustomizers.customize((PlatformTransactionManager)transactionManager);
            }
            return transactionManager;
        }
    }
}

