/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.spanner;

import com.google.cloud.spanner.Key;
import com.google.cloud.spring.data.spanner.core.convert.SpannerEntityProcessor;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerDataException;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerMappingContext;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerPersistentEntity;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerPersistentProperty;
import java.io.Serializable;
import java.util.StringJoiner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.spi.BackendIdConverter;

public class SpannerKeyIdConverter
implements BackendIdConverter {
    private SpannerMappingContext mappingContext;
    @Autowired
    SpannerEntityProcessor spannerEntityProcessor;

    public SpannerKeyIdConverter(SpannerMappingContext mappingContext) {
        this.mappingContext = mappingContext;
    }

    public Serializable fromRequestId(String id, Class<?> entityType) {
        if (id == null) {
            return null;
        }
        SpannerPersistentEntity persistentEntity = (SpannerPersistentEntity)this.mappingContext.getPersistentEntity(entityType);
        if (persistentEntity != null && persistentEntity.hasMultiFieldKey()) {
            return this.fromRequestIdSingleKey(id, (SpannerPersistentProperty)persistentEntity.getIdProperty());
        }
        return this.fromRequestIdCompoundKey(id);
    }

    private Serializable fromRequestIdCompoundKey(String id) {
        Object[] parts = id.split(this.getUrlIdSeparator());
        return Key.of((Object[])parts);
    }

    private Serializable fromRequestIdSingleKey(String id, SpannerPersistentProperty idProperty) {
        Object convertedId = this.spannerEntityProcessor.getReadConverter().convert((Object)id, idProperty.getType());
        if (convertedId instanceof Serializable) {
            return (Serializable)convertedId;
        }
        throw new SpannerDataException("Property type for ID field has to be Serializable");
    }

    protected String getUrlIdSeparator() {
        return ",";
    }

    public String toRequestId(Serializable source, Class<?> entityType) {
        Key id = (Key)source;
        StringJoiner stringJoiner = new StringJoiner(this.getUrlIdSeparator());
        id.getParts().forEach(p -> stringJoiner.add(p.toString()));
        return stringJoiner.toString();
    }

    public boolean supports(Class<?> type) {
        SpannerPersistentEntity persistentEntity = (SpannerPersistentEntity)this.mappingContext.getPersistentEntity(type);
        return persistentEntity != null && persistentEntity.getIdProperty() != null;
    }
}

